/**
JMdRdfToolsGUI
Copyright (C) 2001  Shinichi Hayashi

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package jp.or.fsinet.hayashi.rdf.jmdrdftools.gui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.FlowLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.AWTEvent;
import java.awt.event.*;
import java.util.Iterator;
import javax.swing.*;
import javax.swing.border.TitledBorder;
//import org.apache.xerces.parsers.*;
//import org.w3c.dom.*;
//import org.apache.xml.serialize.*;
//import org.xml.sax.*;
import org.jdom.*;
import org.jdom.input.*;
import org.jdom.output.*;

/**
 * ^Cg:  JMdRdfTools
 * :    JMdRdfGUI[eBeBłB
 * 쌠:   Copyright (c) 2001
 * Ж:
 * @author Shinichi Hayashi
 * @version 1.0
 */

class FilenameAttr extends Object {
    private Attribute attr;
    private final String[] typeAttr={""
            ,"match","notMatch","equals"
            ,"startsWith","endsWith"
            ,"notStartsWith","notEndsWith"
            ,"*"};
    private final String[] typeName={""
            ,"܂","܂܂Ȃ","v"
            ,"ŊJn","ŏI"
            ,"ŊJnȂ","ŏIȂ"
            };

    FilenameAttr(Attribute a){
        attr = a;
    }

    public Attribute getAttribute(){
        return attr;
    }

    public String toString(){
        return "["+attr.getValue()+"] "+type2name(attr.getName());
    }

    public int type2idx() {
        int n=0;
        while(!(typeAttr[n].equals("*"))){
            if (typeAttr[n].equals(attr.getName())){
                return n;
            }
            n++;
        }
        return 0;
    }

    private String type2name(String str) {
        int n=0;
        while(!(typeAttr[n].equals("*"))){
            if (typeAttr[n].equals(str)){
                return typeName[n];
            }
            n++;
        }
        return "";
    }
}

public class Frame extends JFrame {
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JLabel statusBar = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JTextField jtfSourcefile = new JTextField();
    JButton jbtnConf = new JButton();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel8 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JLabel jLabel2 = new JLabel();
    BorderLayout borderLayout5 = new BorderLayout();
    JList jlst2_add = new JList();
    DefaultListModel jlm2_add = new DefaultListModel();
    JPanel jPanel9 = new JPanel();
    JButton jButton5 = new JButton();
    JButton jButton6 = new JButton();
    TitledBorder titledBorder1;
    String[] data2={"debug","test"};
    String[] data3={"[db1]܂","[db2]܂܂Ȃ","[db3]v","[db4]ŊJn","[db5]ŏI","[db6]ŊJnȂ","[db7]ŏIȂ"};
    JScrollPane jScrollPane3 = new JScrollPane();
    JLabel jLabel5 = new JLabel();
    JPanel jPanel19 = new JPanel();
    BorderLayout borderLayout15 = new BorderLayout();
    JPanel jPanel20 = new JPanel();
    BorderLayout borderLayout16 = new BorderLayout();
    JPanel jPanel21 = new JPanel();
    JPanel jPanel17 = new JPanel();
    JPanel jPanel18 = new JPanel();
    GridLayout gridLayout3 = new GridLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel jPanel22 = new JPanel();
    BorderLayout borderLayout13 = new BorderLayout();
    JPanel jPanel23 = new JPanel();
    JLabel jLabel6 = new JLabel();
    BorderLayout borderLayout14 = new BorderLayout();
    JPanel jPanel24 = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    BorderLayout borderLayout6 = new BorderLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    JList jlst3_del = new JList();
    DefaultListModel jlm3_del = new DefaultListModel();
    JScrollPane jScrollPane4 = new JScrollPane();
    BorderLayout borderLayout7 = new BorderLayout();
    BorderLayout borderLayout8 = new BorderLayout();
    JPanel jPanel10 = new JPanel();
    JPanel jPanel11 = new JPanel();
    JButton jButton7 = new JButton();
    JButton jButton8 = new JButton();
    JPanel jPanel7 = new JPanel();
    JLabel jLabel3 = new JLabel();
    JPanel jPanel5 = new JPanel();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JPanel jPanel12 = new JPanel();
    BorderLayout borderLayout9 = new BorderLayout();
    JPanel jPanel13 = new JPanel();
    BorderLayout borderLayout12 = new BorderLayout();
    JLabel jLabel7 = new JLabel();
    JPanel jPanel25 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel26 = new JPanel();
    JTextArea jTextArea1 = new JTextArea();
    JTextField jtf1_link = new JTextField();
    JPanel jPanel27 = new JPanel();
    BorderLayout borderLayout17 = new BorderLayout();
    JTextField jtf1_language = new JTextField();
    JTextArea jTextArea2 = new JTextArea();
    JPanel jPanel28 = new JPanel();
    JPanel jPanel29 = new JPanel();
    BorderLayout borderLayout18 = new BorderLayout();
    JPanel jPanel31 = new JPanel();
    BorderLayout borderLayout19 = new BorderLayout();
    JTextField jtf1_copyright = new JTextField();
    JTextArea jTextArea3 = new JTextArea();
    JPanel jPanel210 = new JPanel();
    JPanel jPanel211 = new JPanel();
    BorderLayout borderLayout110 = new BorderLayout();
    JTextField jtf1_description = new JTextField();
    JTextArea jTextArea4 = new JTextArea();
    JPanel jPanel212 = new JPanel();
    JPanel jPanel213 = new JPanel();
    BorderLayout borderLayout111 = new BorderLayout();
    JTextField jtf1_title = new JTextField();
    JTextArea jTextArea5 = new JTextArea();
    JPanel jPanel214 = new JPanel();
    JPanel jPanel215 = new JPanel();
    BorderLayout borderLayout112 = new BorderLayout();
    JTextField jtf1_filename = new JTextField();
    JTextArea jTextArea6 = new JTextArea();
    BorderLayout borderLayout113 = new BorderLayout();
    JPanel jPanel216 = new JPanel();
    JPanel jPanel217 = new JPanel();
    JLabel jLabel8 = new JLabel();
    JTextArea jTextArea7 = new JTextArea();
    JTextField jtf1_baseuri = new JTextField();
    JPanel jPanel218 = new JPanel();
    JLabel jLabel9 = new JLabel();
    JPanel jPanel219 = new JPanel();
    BorderLayout borderLayout114 = new BorderLayout();
    FlowLayout flowLayout3 = new FlowLayout();

    // xerces
    // DOMParser dom = new DOMParser ();
    // Document doc;

    // JDOM
    /** Default SAX Driver class to use */
    private static final String DEFAULT_SAX_DRIVER_CLASS =
        "org.apache.xerces.parsers.SAXParser";
    /** SAX Driver Class to use */
    private String saxDriverClass = DEFAULT_SAX_DRIVER_CLASS;
    /** <code>{@link SAXBuilder}</code> instance to use */
    private SAXBuilder builder;
    private Document doc;
    private Element channel,param,select;
    private boolean file_new=true;

    JOptionPane jOptionPane1 = new JOptionPane();
    JPanel jPanel30 = new JPanel();
    JPanel jPanel32 = new JPanel();
    JTextField jtf5_value = new JTextField();
    JButton jButton11 = new JButton();
    GridLayout gridLayout4 = new GridLayout();
    String[] data4={"","T",""};
    JComboBox jcb5_type = new JComboBox(data4);
    JCheckBox jcb5_filedate = new JCheckBox();
    GridLayout gridLayout5 = new GridLayout();
    JButton jButton9 = new JButton();
    JPanel jPanel14 = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    BorderLayout borderLayout10 = new BorderLayout();
    JPanel jPanel15 = new JPanel();
    JButton jButton3 = new JButton();
    FlowLayout flowLayout4 = new FlowLayout();
    JTextArea jta6_source = new JTextArea();
    JCheckBox jcb4_sort = new JCheckBox();
    String[] data5={"XV","t@C"};
    JComboBox jcb4_order = new JComboBox(data5);
    String[] data6={"","~"};
    JComboBox jcb4_desc = new JComboBox(data6);
    JFileChooser jFileChooser1 = new JFileChooser();

    /**t[̍\z*/
    public Frame() {
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);
        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    /**R|[lg̏*/
    private void jbInit() throws Exception  {
        //setIconImage(Toolkit.getDefaultToolkit().createImage(Frame.class.getResource("[Your Icon]")));
        contentPane = (JPanel) this.getContentPane();
        titledBorder1 = new TitledBorder("");
        contentPane.setLayout(borderLayout1);
        this.setSize(new Dimension(637, 480));
        this.setTitle("JMdRdfToolsGUI");
        statusBar.setText(" ");
        jMenuFile.setText("t@C");
        jMenuFileExit.setText("I");
        jMenuFileExit.addActionListener(new ActionListener()  {
            public void actionPerformed(ActionEvent e) {
                jMenuFileExit_actionPerformed(e);
            }
        });
        jMenuHelp.setText("wv");
        jMenuHelpAbout.setText("o[W");
        jMenuHelpAbout.addActionListener(new ActionListener()  {
            public void actionPerformed(ActionEvent e) {
                jMenuHelpAbout_actionPerformed(e);
            }
        });
        jPanel1.setLayout(borderLayout2);
        jLabel1.setText("t@CF");
        jtfSourcefile.setText("e:\\test.xml");
        jtfSourcefile.setColumns(20);
        jbtnConf.setText("...");
        jbtnConf.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jbtnConf_actionPerformed(e);
            }
        });
        jPanel2.setBackground(Color.orange);
        jPanel2.setLayout(borderLayout3);
        jPanel3.setBackground(Color.orange);
        jPanel4.setLayout(borderLayout6);
        jPanel6.setLayout(borderLayout4);
        jLabel2.setBackground(Color.lightGray);
        jLabel2.setText("ǉ");
        jPanel8.setLayout(borderLayout5);
        jPanel8.setBackground(Color.green);
        jButton5.setForeground(Color.blue);
        jButton5.setText("ǉ");
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jButton5_actionPerformed(e);
            }
        });
        jButton6.setForeground(Color.red);
        jButton6.setText("폜");
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jButton6_actionPerformed(e);
            }
        });
        jPanel6.setBorder(BorderFactory.createEtchedBorder());
        jLabel5.setText("\");
        jPanel19.setLayout(borderLayout15);
        jPanel20.setLayout(borderLayout16);
        jPanel20.setBackground(Color.green);
        jPanel21.setLayout(flowLayout1);
        jPanel17.setLayout(flowLayout2);
        jPanel18.setLayout(gridLayout3);
        gridLayout3.setRows(2);
        gridLayout3.setColumns(1);
        jPanel22.setLayout(borderLayout13);
        jPanel23.setBackground(Color.green);
        jPanel23.setLayout(borderLayout14);
        jLabel6.setToolTipText("");
        jLabel6.setText("t͈");
        jPanel24.setLayout(gridLayout2);
        gridLayout2.setRows(10);
        jPanel9.setBorder(BorderFactory.createEtchedBorder());
        jPanel9.setLayout(gridLayout4);
        jPanel10.setBorder(BorderFactory.createEtchedBorder());
        jPanel10.setLayout(gridLayout5);
        jPanel11.setLayout(borderLayout7);
        jPanel11.setBackground(Color.green);
        jButton7.setActionCommand("ύX");
        jButton7.setText("ύX");
        jButton7.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jButton7_actionPerformed(e);
            }
        });
        jButton8.setForeground(Color.blue);
        jButton8.setText("ǉ");
        jButton8.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jButton8_actionPerformed(e);
            }
        });
        jPanel7.setLayout(borderLayout8);
        jPanel7.setBorder(BorderFactory.createEtchedBorder());
        jLabel3.setBackground(Color.lightGray);
        jLabel3.setText("O");
        jButton1.setText("ۑ");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jButton1_actionPerformed(e);
            }
        });
        jPanel5.setBackground(Color.orange);
        jButton2.setText("J");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jButton2_actionPerformed(e);
            }
        });
        jPanel12.setLayout(borderLayout9);
        jPanel13.setLayout(borderLayout12);
        jLabel7.setText("{ݒ");
        jPanel13.setBackground(Color.yellow);
        jPanel25.setLayout(gridLayout1);
        gridLayout1.setRows(10);
        jTextArea1.setColumns(10);
        jTextArea1.setText("N");
        jTextArea1.setBackground(Color.orange);
        jTextArea1.setFont(new java.awt.Font("DialogInput", 0, 12));
        jPanel26.setLayout(borderLayout17);
        jtf1_link.setFont(new java.awt.Font("DialogInput", 0, 12));
        jtf1_link.setColumns(70);
        jtf1_link.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(FocusEvent e) {
                jtf1_link_focusLost(e);
            }
        });
        jtf1_language.setFont(new java.awt.Font("DialogInput", 0, 12));
        jtf1_language.setColumns(70);
        jtf1_language.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(FocusEvent e) {
                jtf1_language_focusLost(e);
            }
        });
        jTextArea2.setBackground(Color.orange);
        jTextArea2.setFont(new java.awt.Font("DialogInput", 0, 12));
        jTextArea2.setColumns(10);
        jTextArea2.setText("");
        jPanel29.setLayout(borderLayout18);
        jPanel31.setLayout(borderLayout19);
        jtf1_copyright.setFont(new java.awt.Font("DialogInput", 0, 12));
        jtf1_copyright.setColumns(70);
        jtf1_copyright.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(FocusEvent e) {
                jtf1_copyright_focusLost(e);
            }
        });
        jTextArea3.setColumns(10);
        jTextArea3.setText("쌠");
        jTextArea3.setBackground(Color.orange);
        jTextArea3.setFont(new java.awt.Font("DialogInput", 0, 12));
        jPanel210.setLayout(borderLayout110);
        jtf1_description.setFont(new java.awt.Font("DialogInput", 0, 12));
        jtf1_description.setColumns(70);
        jtf1_description.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(FocusEvent e) {
                jtf1_description_focusLost(e);
            }
        });
        jTextArea4.setColumns(10);
        jTextArea4.setText("");
        jTextArea4.setBackground(Color.orange);
        jTextArea4.setFont(new java.awt.Font("DialogInput", 0, 12));
        jPanel212.setLayout(borderLayout111);
        jtf1_title.setFont(new java.awt.Font("DialogInput", 0, 12));
        jtf1_title.setColumns(70);
        jtf1_title.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(FocusEvent e) {
                jtf1_title_focusLost(e);
            }
        });
        jTextArea5.setColumns(10);
        jTextArea5.setText("^Cg");
        jTextArea5.setBackground(Color.orange);
        jTextArea5.setFont(new java.awt.Font("DialogInput", 0, 12));
        jPanel214.setLayout(borderLayout112);
        jtf1_filename.setFont(new java.awt.Font("DialogInput", 0, 12));
        jtf1_filename.setColumns(20);
        jtf1_filename.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(FocusEvent e) {
                jtf1_filename_focusLost(e);
            }
        });
        jTextArea6.setBackground(Color.green);
        jTextArea6.setFont(new java.awt.Font("DialogInput", 0, 12));
        jTextArea6.setText("t@C");
        jTextArea6.setColumns(10);
        jPanel217.setLayout(borderLayout113);
        jLabel8.setFont(new java.awt.Font("Dialog", 1, 14));
        jLabel8.setToolTipText("");
        jLabel8.setText(".rss1.0(and .rss0.9).xml");
        jTextArea7.setColumns(10);
        jTextArea7.setText("BaseURI");
        jTextArea7.setBackground(Color.green);
        jTextArea7.setFont(new java.awt.Font("DialogInput", 0, 12));
        jtf1_baseuri.setFont(new java.awt.Font("DialogInput", 0, 12));
        jtf1_baseuri.setColumns(46);
        jtf1_baseuri.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(FocusEvent e) {
                jtf1_baseuri_focusLost(e);
            }
        });
        jPanel218.setLayout(borderLayout114);
        jLabel9.setFont(new java.awt.Font("Dialog", 1, 12));
        jLabel9.setToolTipText("");
        jLabel9.setText(" ex. http://hoge.org/foo/bar/ ");
        jPanel219.setLayout(flowLayout3);
        jtf5_value.setEnabled(false);
        jtf5_value.setFont(new java.awt.Font("DialogInput", 0, 12));
        jtf5_value.setText("1");
        jtf5_value.setColumns(3);
        jtf5_value.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(FocusEvent e) {
                jtf5_value_focusLost(e);
            }
        });
        jlst2_add.setFont(new java.awt.Font("DialogInput", 0, 12));
        jlst2_add.setToolTipText("");
        jButton11.setText("ύX");
        jButton11.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jButton11_actionPerformed(e);
            }
        });
        gridLayout4.setRows(12);
        jcb5_filedate.setText("ݒ肷");
        jcb5_filedate.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                jcb5_filedate_itemStateChanged(e);
            }
        });
        jcb5_type.setEnabled(false);
        jcb5_type.setFont(new java.awt.Font("DialogInput", 0, 12));
        jcb5_type.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                jcb5_type_itemStateChanged(e);
            }
        });
        gridLayout5.setRows(12);
        jButton9.setText("폜");
        jButton9.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jButton9_actionPerformed(e);
            }
        });
        jButton9.setForeground(Color.red);
        jPanel14.setLayout(borderLayout10);
        jButton3.setBackground(Color.blue);
        jButton3.setForeground(Color.white);
        jButton3.setText("ŐV\");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jButton3_actionPerformed(e);
            }
        });
        jPanel15.setLayout(flowLayout4);
        jcb4_sort.setText("ݒ肷");
        jcb4_sort.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                jcb4_sort_itemStateChanged(e);
            }
        });
        jcb4_order.setEnabled(false);
        jcb4_order.setFont(new java.awt.Font("DialogInput", 0, 12));
        jcb4_order.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                jcb4_order_itemStateChanged(e);
            }
        });
        jcb4_desc.setEnabled(false);
        jcb4_desc.setFont(new java.awt.Font("DialogInput", 0, 12));
        jcb4_desc.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                jcb4_desc_itemStateChanged(e);
            }
        });
        jlst3_del.setFont(new java.awt.Font("DialogInput", 0, 12));
        jta6_source.setFont(new java.awt.Font("DialogInput", 0, 12));
        jFileChooser1.setDialogTitle("");
        jFileChooser1.setApproveButtonText("");
        jFileChooser1.setApproveButtonToolTipText("");
        jFileChooser1.setToolTipText("");
        jFileChooser1.setFileFilter(new XMLFilter());
        jMenuFile.add(jMenuFileExit);
        jMenuHelp.add(jMenuHelpAbout);
        jMenuBar1.add(jMenuFile);
        jMenuBar1.add(jMenuHelp);
        this.setJMenuBar(jMenuBar1);
        contentPane.add(statusBar, BorderLayout.SOUTH);
        contentPane.add(jPanel1, BorderLayout.CENTER);
        jPanel1.add(jTabbedPane1, BorderLayout.CENTER);
        jTabbedPane1.add(jPanel12, "{ݒ");
        jPanel12.add(jPanel13, BorderLayout.CENTER);
        jPanel13.add(jLabel7, BorderLayout.NORTH);
        jPanel13.add(jPanel25, BorderLayout.CENTER);
        jPanel25.add(jPanel26, null);
        jPanel25.add(jPanel214, null);
        jPanel214.add(jPanel215, BorderLayout.WEST);
        jPanel215.add(jTextArea5, null);
        jPanel215.add(jtf1_title, null);
        jPanel25.add(jPanel212, null);
        jPanel212.add(jPanel213, BorderLayout.WEST);
        jPanel213.add(jTextArea4, null);
        jPanel213.add(jtf1_description, null);
        jPanel25.add(jPanel31, null);
        jPanel31.add(jPanel27, BorderLayout.WEST);
        jPanel27.add(jTextArea1, null);
        jPanel27.add(jtf1_link, null);
        jPanel25.add(jPanel29, null);
        jPanel29.add(jPanel28, BorderLayout.WEST);
        jPanel28.add(jTextArea2, null);
        jPanel28.add(jtf1_language, null);
        jPanel25.add(jPanel210, null);
        jPanel210.add(jPanel211, BorderLayout.WEST);
        jPanel211.add(jTextArea3, null);
        jPanel211.add(jtf1_copyright, null);
        jPanel25.add(jPanel217, null);
        jPanel217.add(jPanel216, BorderLayout.WEST);
        jPanel216.add(jTextArea6, null);
        jPanel216.add(jtf1_filename, null);
        jPanel216.add(jLabel8, null);
        jPanel25.add(jPanel218, null);
        jPanel218.add(jPanel219, BorderLayout.WEST);
        jPanel219.add(jTextArea7, null);
        jPanel219.add(jtf1_baseuri, null);
        jPanel219.add(jLabel9, null);
        jTabbedPane1.add(jPanel6, "ǉ");
        jPanel6.add(jPanel8, BorderLayout.NORTH);
        jPanel8.add(jLabel2, BorderLayout.CENTER);
        jPanel6.add(jPanel9, BorderLayout.EAST);
        jPanel9.add(jButton5, null);
        jPanel9.add(jButton11, null);
        jPanel9.add(jButton6, null);
        jPanel6.add(jScrollPane3, BorderLayout.CENTER);
        jTabbedPane1.add(jPanel7, "O");
        jPanel7.add(jPanel11, BorderLayout.NORTH);
        jPanel11.add(jLabel3, BorderLayout.CENTER);
        jPanel7.add(jPanel10, BorderLayout.EAST);
        jPanel10.add(jButton8, null);
        jPanel10.add(jButton7, null);
        jPanel10.add(jButton9, null);
        jPanel7.add(jScrollPane4, BorderLayout.CENTER);
        jTabbedPane1.add(jPanel4, "\");
        jPanel4.add(jPanel19, BorderLayout.NORTH);
        jPanel19.add(jPanel20, BorderLayout.NORTH);
        jPanel20.add(jLabel5, BorderLayout.WEST);
        jPanel19.add(jPanel18, BorderLayout.CENTER);
        jPanel18.add(jPanel21, null);
        jPanel18.add(jPanel17, null);
        jPanel17.add(jcb4_sort, null);
        jPanel17.add(jcb4_order, null);
        jPanel17.add(jcb4_desc, null);
        jTabbedPane1.add(jPanel22, "t͈");
        jPanel22.add(jPanel23, BorderLayout.CENTER);
        jPanel23.add(jLabel6, BorderLayout.NORTH);
        jPanel23.add(jPanel24, BorderLayout.CENTER);
        jPanel24.add(jPanel30, null);
        jPanel24.add(jPanel32, null);
        jPanel32.add(jcb5_filedate, null);
        jPanel32.add(jtf5_value, null);
        jPanel32.add(jcb5_type, null);
        jTabbedPane1.add(jPanel14, "\[X");
        jPanel14.add(jScrollPane1, BorderLayout.CENTER);
        jScrollPane1.getViewport().add(jta6_source, null);
        jPanel14.add(jPanel15, BorderLayout.SOUTH);
        jPanel15.add(jButton3, null);
        jScrollPane4.getViewport().add(jlst3_del, null);
        jScrollPane3.getViewport().add(jlst2_add, null);
        jPanel1.add(jPanel2, BorderLayout.NORTH);
        jPanel2.add(jPanel3, BorderLayout.WEST);
        jPanel3.add(jLabel1, null);
        jPanel3.add(jtfSourcefile, null);
        jPanel3.add(jbtnConf, null);
        jPanel3.add(jButton2, null);
        jPanel2.add(jPanel5, BorderLayout.EAST);
        jPanel5.add(jButton1, null);

        // JDOM
        this.saxDriverClass = saxDriverClass;
        builder = new SAXBuilder(saxDriverClass);

        // JMdRdf 
        Comment head = new Comment("JMdRdf definition file generated by JMdEdfToolsGUI");
        Element root = new Element("jmdrdf").setAttribute("version","1.0").addContent(head);
        channel = new Element("channel");
        param = new Element("param");
        select = new Element("select");
        root.addContent(channel);
        root.addContent(param);
        root.addContent(select);
        doc = new Document(root);
        refresh_source();

        // model
        jlst2_add.setModel(jlm2_add);
        jlst3_del.setModel(jlm3_del);
    }
    /**[t@C|I]*/
    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }
    /**[wv|o[W]*/
    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        Frame_AboutBox dlg = new Frame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = getSize();
        Point loc = getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }
    /**EBhEꂽƂɏI悤ɃI[o[Ch*/
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            jMenuFileExit_actionPerformed(null);
        }
    }

    protected void setText2(JTextField obj,Element elm){
        if (elm != null && elm.getText() != null){
            obj.setText(elm.getText());
        }else{
            obj.setText("");
        }
    }

    void jButton2_actionPerformed(ActionEvent e) {
        try {
            // XMLt@C
            file_new=false;
            doc = builder.build(new File(jtfSourcefile.getText()));
            channel = doc.getRootElement().getChild("channel");
            param = doc.getRootElement().getChild("param");
            select = doc.getRootElement().getChild("select");

            // {
            setText2(jtf1_title         ,channel.getChild("title"));
            setText2(jtf1_description   ,channel.getChild("description"));
            setText2(jtf1_link          ,channel.getChild("link"));
            setText2(jtf1_language      ,channel.getChild("language"));
            setText2(jtf1_copyright     ,channel.getChild("copyright"));
            setText2(jtf1_filename      ,param.getChild("filename"));
            setText2(jtf1_baseuri       ,param.getChild("baseuri"));

            // ǉ
            refresh_filename(jlm2_add,select,"add");
            // O
            refresh_filename(jlm3_del,select,"remove");
            // \[g
            refresh_sort();
            // ͈
            refresh_filedate();
            // \[X
            refresh_source();

        } catch (JDOMException exp) {
            if (exp.getCause() != null) {
                exp.getCause().printStackTrace();
                jOptionPane1.showMessageDialog(
                    this.getContentPane(),
                    exp.getCause().getMessage(),
                    "G[",
                    jOptionPane1.ERROR_MESSAGE);
            } else {
                exp.printStackTrace();
                jOptionPane1.showMessageDialog(
                    this.getContentPane(),
                    exp.getMessage(),
                    "G[",
                    jOptionPane1.ERROR_MESSAGE);
            }
        } catch (Exception exp) {
            exp.printStackTrace();
            jOptionPane1.showMessageDialog(
                this.getContentPane(),
                exp.getMessage(),
                "G[",
                jOptionPane1.ERROR_MESSAGE);
        }
/*      try{
            // XMLt@C
            dom.parse(jtfSourcefile.getText());
            doc = dom.getDocument();
            // \
//          printElement(doc.getDocumentElement());
            jtf1_title.setText(      getValue(doc, "channel", "title"));
            jtf1_description.setText(getValue(doc, "channel", "description"));
            jtf1_link.setText(       getValue(doc, "channel", "link"));
            jtf1_language.setText(   getValue(doc, "channel", "language"));
            jtf1_copyright.setText(  getValue(doc, "channel", "copyright"));
            jtf1_filename.setText(   getValue(doc, "param"  , "filename"));
            jtf1_baseuri.setText(    getValue(doc, "param"  , "baseuri"));
            jButton1.setEnabled(true);
        }catch(Exception exp){
            exp.printStackTrace();
            jOptionPane1.showMessageDialog(
                this.getContentPane(),
                exp.getMessage(),
                "G[",
                jOptionPane1.ERROR_MESSAGE);
        }
*/  }
/*
    static private Node find(Document document, String elm1, String elm2) {
        NodeList children,children2;
        Element docRoot = document.getDocumentElement();

        NodeList elements = docRoot.getElementsByTagName(elm1);
        if (elements !=  null) {
            for (int i = 0; i<elements.getLength(); i++) {
                if (elements.item(i).hasChildNodes()) {
                    children = elements.item(i).getChildNodes();
                    for (int k = 0; k<children.getLength(); k++) {
                        if (children.item(k).getNodeType() == org.w3c.dom.Node.ELEMENT_NODE) {
                            if (children.item(k).getNodeName().equals(elm2)) {
                                if (children.item(k).hasChildNodes()) {
                                    children2 = children.item(k).getChildNodes();
                                    for (int m = 0; m<children2.getLength(); m++) {
                                        if (children2.item(m).getNodeType() == org.w3c.dom.Node.TEXT_NODE) {
                                            return children2.item(m);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    static private void setValue(Document document, String elm1, String elm2, String valueToReplace) {
        Node item = find(document, elm1,elm2);
        if (item != null){
            item.setNodeValue(valueToReplace);
        }
    }

    static private String getValue(Document document, String elm1, String elm2) {
        Node item = find(document, elm1,elm2);
        if (item != null){
            return item.getNodeValue();
        }
        return null;
    }

    private static void printElement(Element element) {
        int k;
        NamedNodeMap attributes;
        NodeList children = element.getChildNodes();
        //***** Start this element
        System.out.print("<" + element.getNodeName());
        //***** Get any attibutes and print them inside the element start tag
        attributes = element.getAttributes();
        if (attributes != null) {
            for (k = 0; k < attributes.getLength(); k++) {
                System.out.print(" " + attributes.item(k).getNodeName());
                System.out.print("=" + attributes.item(k).getNodeValue());
            }
        }
        if (element.hasChildNodes()) { //***** If this element has a value or sub-elements
            System.out.print(">");
            //** For each child, if the child is an element call print element to print that
            //** portion of the tree, if it is a text node, print the text to stdout.
            //** All other node types are ignored for the sake of simplicity.

            for (k = 0; k < children.getLength(); k++) {
                if (children.item(k).getNodeType() == org.w3c.dom.Node.ELEMENT_NODE) {
                    printElement((Element) children.item(k));
                } else if (children.item(k).getNodeType() == org.w3c.dom.Node.TEXT_NODE) {
                    System.out.print(children.item(k).getNodeValue());
                }
            }     // end for loop
            //***** Add a closing tag
            System.out.print("");
        }// end else
    }
*/
    void jButton1_actionPerformed(ActionEvent e) {
        try {
            XMLOutputter outputter;
            if (file_new){
                outputter = new XMLOutputter("    ",true);
            }else{
                outputter = new XMLOutputter();
            }
//          outputter.output(doc, System.out);
            FileOutputStream fos = new FileOutputStream(new File(jtfSourcefile.getText()));
            outputter.output(doc, fos);
            fos.flush();
            fos.close();
            jOptionPane1.showMessageDialog(
                this.getContentPane(),
                "ۑI܂B",
                "ۑ",
                jOptionPane1.INFORMATION_MESSAGE);
        } catch (Exception exp) {
            exp.printStackTrace();
            jOptionPane1.showMessageDialog(
                this.getContentPane(),
                exp.getMessage(),
                "G[",
                jOptionPane1.ERROR_MESSAGE);
        }

/*      try {
            OutputFormat    format  = new OutputFormat( doc,"UTF-8",true );   //Serialize DOM
            format.setPreserveSpace(true);
            StringWriter  stringOut = new StringWriter();        //Writer will be a String
            XMLSerializer    serial = new XMLSerializer( stringOut, format );
            serial.asDOMSerializer();                            // As a DOM Serializer
            serial.serialize( doc.getDocumentElement() );

            FileOutputStream fos = new FileOutputStream(new File(jtfSourcefile.getText()));
            fos.write(stringOut.toString().getBytes("UTF-8"));
            fos.close();
//          System.out.println( stringOut.toString() ); //Spit out DOM as a String
            jOptionPane1.showMessageDialog(
                this.getContentPane(),
                "ۑI܂B",
                "ۑ",
                jOptionPane1.INFORMATION_MESSAGE);
        } catch ( Exception exp ) {
            exp.printStackTrace();
            jOptionPane1.showMessageDialog(
                this.getContentPane(),
                exp.getMessage(),
                "G[",
                jOptionPane1.ERROR_MESSAGE);
        }
*/  }

    void setValue(Element elm,String child,String str){
        if (elm.getChildren(child).isEmpty()){
            // qvfȂ̂ō쐬
            elm.addContent(new Element(child).setText(str));
        }else{
            elm.getChild(child).setText(str);
        }
    }

    void jtf1_title_focusLost(FocusEvent e) {
        setValue(channel,"title",jtf1_title.getText());
        refresh_source();
//      setValue(doc, "channel", "title",jtf1_title.getText());
    }

    void jtf1_description_focusLost(FocusEvent e) {
        setValue(channel,"description",jtf1_description.getText());
        refresh_source();
//      setValue(doc, "channel", "description",jtf1_description.getText());
    }

    void jtf1_link_focusLost(FocusEvent e) {
        setValue(channel,"link",jtf1_link.getText());
        refresh_source();
//      setValue(doc, "channel", "link",jtf1_link.getText());
    }

    void jtf1_language_focusLost(FocusEvent e) {
        setValue(channel,"language",jtf1_language.getText());
        refresh_source();
//      setValue(doc, "channel", "language",jtf1_language.getText());
    }

    void jtf1_copyright_focusLost(FocusEvent e) {
        setValue(channel,"copyright",jtf1_copyright.getText());
        refresh_source();
//      setValue(doc, "channel", "copyright",jtf1_copyright.getText());
    }

    void jtf1_filename_focusLost(FocusEvent e) {
        setValue(param,"filename",jtf1_filename.getText());
        refresh_source();
//      setValue(doc, "param"  , "filename",jtf1_filename.getText());
    }

    void jtf1_baseuri_focusLost(FocusEvent e) {
        setValue(param,"baseuri",jtf1_baseuri.getText());
        refresh_source();
//      setValue(doc, "param"  , "baseuri",jtf1_baseuri.getText());
    }

    void jButton5_actionPerformed(ActionEvent e) {
        DlgFilename dlg = new DlgFilename(this,"ǉt@Cݒ",true);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = getSize();
        Point loc = getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.show();
        if (dlg.isOK()){
            // XMLύX
            select.addContent(new Element("add")
                .addContent(new Element("filename")
                    .setAttribute(dlg.getType(),dlg.getFilename())));
            // ꗗXV
            refresh_filename(jlm2_add,select,"add");
        }
   }

    void jButton11_actionPerformed(ActionEvent e) {
        if (jlst2_add.getSelectedIndex()==-1){
            jOptionPane1.showMessageDialog(
                this.getContentPane(),
                "ύXsIĉB",
                "G[",
                jOptionPane1.ERROR_MESSAGE);
                return;
        }
        DlgFilename dlg = new DlgFilename(this,"ǉt@CύX",true);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = getSize();
        Point loc = getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        FilenameAttr attr = (FilenameAttr)jlst2_add.getSelectedValue();
        dlg.setFilename(attr.getAttribute().getValue());
        dlg.setType(attr.type2idx());
        dlg.show();
        if (dlg.isOK()){
            // XMLύX
            Element elm=attr.getAttribute().getParent();
            elm.removeAttribute(attr.getAttribute().getName());
            elm.setAttribute(dlg.getType(),dlg.getFilename());
            // ꗗXV
            refresh_filename(jlm2_add,select,"add");
        }
    }

    void jButton6_actionPerformed(ActionEvent e) {
        // XMLύX
        FilenameAttr attr=(FilenameAttr)jlst2_add.getSelectedValue();
        Element elm=attr.getAttribute().getParent();
        elm.removeAttribute(attr.getAttribute().getName());
        // ꗗXV
        refresh_filename(jlm2_add,select,"add");
    }

    void jButton3_actionPerformed(ActionEvent e) {
        refresh_source();
    }

    void refresh_filename(DefaultListModel dlm,Element elm,String idx){
        dlm.clear();
        Iterator itr = elm.getChildren(idx).iterator();
        while (itr.hasNext()) {
            Element elmIDX = (Element)itr.next();
            Element filename = elmIDX.getChild("filename");
            Iterator itrAttr = filename.getAttributes().iterator();
            while (itrAttr.hasNext()) {
                FilenameAttr attr = new FilenameAttr((Attribute)itrAttr.next());
                dlm.addElement(attr);
            }
        }
        refresh_source();
    }

    void refresh_source(){
        try {
            // Create an outputter with default formatting
            XMLOutputter outputter;
            if (file_new){
                outputter = new XMLOutputter("    ",true);
            }else{
                outputter = new XMLOutputter();
            }

            jta6_source.setText(outputter.outputString(doc));
        } catch (Exception exp) {
            exp.printStackTrace();
            jOptionPane1.showMessageDialog(
                this.getContentPane(),
                exp.getMessage(),
                "G[",
                jOptionPane1.ERROR_MESSAGE);
        }
    }

    void jButton8_actionPerformed(ActionEvent e) {
        DlgFilename dlg = new DlgFilename(this,"Ot@Cݒ",true);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = getSize();
        Point loc = getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.show();
        if (dlg.isOK()){
            // XMLύX
            select.addContent(new Element("remove")
                .addContent(new Element("filename")
                    .setAttribute(dlg.getType(),dlg.getFilename())));
            // ꗗXV
            refresh_filename(jlm3_del,select,"remove");
        }
    }

    void jButton7_actionPerformed(ActionEvent e) {
        if (jlst3_del.getSelectedIndex()==-1){
            jOptionPane1.showMessageDialog(
                this.getContentPane(),
                "ύXsIĉB",
                "G[",
                jOptionPane1.ERROR_MESSAGE);
                return;
        }
        DlgFilename dlg = new DlgFilename(this,"Ot@CύX",true);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = getSize();
        Point loc = getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        FilenameAttr attr = (FilenameAttr)jlst3_del.getSelectedValue();
        dlg.setFilename(attr.getAttribute().getValue());
        dlg.setType(attr.type2idx());
        dlg.show();
        if (dlg.isOK()){
            // XMLύX
            Element elm=attr.getAttribute().getParent();
            elm.removeAttribute(attr.getAttribute().getName());
            elm.setAttribute(dlg.getType(),dlg.getFilename());
            // ꗗXV
            refresh_filename(jlm3_del,select,"remove");
        }
    }

    void jButton9_actionPerformed(ActionEvent e) {
        // XMLύX
        FilenameAttr attr=(FilenameAttr)jlst3_del.getSelectedValue();
        Element elm=attr.getAttribute().getParent();
        elm.removeAttribute(attr.getAttribute().getName());
        // ꗗXV
        refresh_filename(jlm3_del,select,"remove");
    }

    void setFiledate() {
        if (!(select.getChildren("where").isEmpty())){
            select.removeChild("where");
        }
        if (jcb5_filedate.isSelected()){
            // XMLǉ
            String[] strValue={"day","week","month"};
            Element elm= new Element("where");
            elm.setAttribute("key","filedate");
            elm.setAttribute("value",strValue[jcb5_type.getSelectedIndex()]);
            elm.setAttribute("count",jtf5_value.getText());
            select.addContent(elm);
        }
        refresh_source();
    }

    void refresh_filedate() {
        if (!(select.getChildren("where").isEmpty())){
            Element elm=select.getChild("where");
            String value = elm.getAttributeValue("value");
            jcb5_type.setSelectedIndex(0);
            String[] strValue={"day","week","month","*"};
            int n=0;
            while(!(strValue[n].equals("*"))){
                if (strValue[n].equals(value)){
                    jcb5_type.setSelectedIndex(n);
                    break;
                }
                n++;
            }
            jtf5_value.setText(elm.getAttributeValue("count"));
            jtf5_value.setEnabled(true);
            jcb5_type.setEnabled(true);
            jcb5_filedate.setSelected(true);
        }else{
            jtf5_value.setEnabled(false);
            jcb5_type.setEnabled(false);
            jcb5_filedate.setSelected(false);
        }
    }

    void jcb5_filedate_itemStateChanged(ItemEvent e) {
        if (e.getStateChange()==e.SELECTED){
            jtf5_value.setEnabled(true);
            jcb5_type.setEnabled(true);
        }else{
            jtf5_value.setEnabled(false);
            jcb5_type.setEnabled(false);
        }
        // XMLXV
        setFiledate();
    }

    void jtf5_value_focusLost(FocusEvent e) {
        // XMLXV
        setFiledate();
    }

    void jcb5_type_itemStateChanged(ItemEvent e) {
        // XMLXV
        setFiledate();
    }

    void setSort() {
        if (!(select.getChildren("sort").isEmpty())){
            select.removeChild("sort");
        }
        if (jcb4_sort.isSelected()){
            // XMLǉ
            String[] strOrder={"filedate","filename"};
            String[] strDesc={"false","true"};
            Element elm= new Element("sort");
            elm.setAttribute("order",strOrder[jcb4_order.getSelectedIndex()]);
            elm.setAttribute("desc",strDesc[jcb4_desc.getSelectedIndex()]);
            select.addContent(elm);
        }
        refresh_source();
    }

    void refresh_sort() {
        if (!(select.getChildren("sort").isEmpty())){
            Element elm=select.getChild("sort");
            String order = elm.getAttributeValue("order");
            jcb4_order.setSelectedIndex(0);
            jcb4_desc.setSelectedIndex(0);
            String[] strOrder={"filedate","filename","*"};
            int n=0;
            while(!(strOrder[n].equals("*"))){
                if (strOrder[n].equals(order)){
                    jcb4_order.setSelectedIndex(n);
                    break;
                }
                n++;
            }
            if (elm.getAttributeValue("desc").equals("true")){
                // ~
                jcb4_order.setSelectedIndex(1);
            }
            jcb4_sort.setSelected(true);
            jcb4_order.setEnabled(true);
            jcb4_desc.setEnabled(true);
        }else{
            jcb4_sort.setSelected(false);
            jcb4_order.setEnabled(false);
            jcb4_desc.setEnabled(false);
        }
    }

    void jcb4_sort_itemStateChanged(ItemEvent e) {
        if (e.getStateChange()==e.SELECTED){
            jcb4_order.setEnabled(true);
            jcb4_desc.setEnabled(true);
        }else{
            jcb4_order.setEnabled(false);
            jcb4_desc.setEnabled(false);
        }
        // XMLXV
        setSort();
    }

    void jcb4_order_itemStateChanged(ItemEvent e) {
        setSort();
    }

    void jcb4_desc_itemStateChanged(ItemEvent e) {
        setSort();
    }

    void jbtnConf_actionPerformed(ActionEvent e) {
        int returnVal = jFileChooser1.showOpenDialog(this);
        if(returnVal == JFileChooser.APPROVE_OPTION) {
            try{
                jtfSourcefile.setText(jFileChooser1.getSelectedFile().getCanonicalPath());
            }catch(IOException ex){
                jOptionPane1.showMessageDialog(
                    this.getContentPane(),
                    "o̓G[܂B("+ex.getMessage()+")",
                    "o̓G[",
                    jOptionPane1.ERROR_MESSAGE);
                ex.printStackTrace();
            }
        }
    }
}

class XMLFilter extends javax.swing.filechooser.FileFilter {
    public boolean accept(File f){
        boolean accept = f.isDirectory();
        if (!accept){
            String suffix = getSuffix(f);
            if (suffix!=null){
                accept = suffix.equals("xml");
            }
        }
        return accept;
    }
    public String getDescription(){
        return("XML Files(*.xml)");
    }
    private String getSuffix(File f){
        String s=f.getPath(),suffix=null;
        int i=s.lastIndexOf('.');
        if (i>0 && i<s.length()-1){
            suffix = s.substring(i+1).toLowerCase();
        }
        return suffix;
    }
}

