/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/09 1:05:32
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.util.Iterator;
import java.util.Properties;

import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author akima
 */
public class StringMapTreeKeyFactory implements MapTreeKeyFactory, MapTree.PropertiesAccessibleSupport {

    /**
     *  
     */
    public StringMapTreeKeyFactory() {
        super();
    }

    protected String stringKeyDelimiter = ".";

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.MapTreeKeyFactory#createKey(java.lang.Object)
     */
    public MapTreeKey createKey(Object object) {
        return new MapTreeKey.Default(toArray(String.valueOf(object)));
    }

    /**
     * ێf[^PropertiesIuWFNgɃVACY܂B
     * 
     * @param properties
     */
    public void saveToProperties(MapTree mapTree, Properties dest) {
        final Properties prop = dest;
        final MapTreeVisitor visitor = new MapTreeVisitor(mapTree.getRoot()) {
            public void doOnLeaf(Object value) {
                final String key = StringUtils.join(keyStack.iterator(), stringKeyDelimiter);
                prop.put(key, value);
            }
        };
        visitor.execute();
    }

    /**
     * PropertiesIuWFNgf[^fVACY܂B
     * 
     * @param properties
     */
    public void loadFromProperties(MapTree mapTree, Properties source) {
        final Iterator iterator = source.keySet().iterator();
        while (iterator.hasNext()) {
            final Object key = iterator.next();
            mapTree.put(createKey(key), source.get(key));
        }
    }

    /**
     * @return Returns the stringKeyDelimiter.
     */
    public String getStringKeyDelimiter() {
        return stringKeyDelimiter;
    }

    /**
     * @param stringKeyDelimiter
     *               The stringKeyDelimiter to set.
     */
    public void setStringKeyDelimiter(String stringKeyDelimiter) {
        this.stringKeyDelimiter = stringKeyDelimiter;
    }

    private Object[] toArray(String keyString) {
        final String keyStr = String.valueOf(keyString);
        return StringUtils.tokenizeToArray(keyStr, stringKeyDelimiter);
    }

}