/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.collection.matrix;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * @author Akima
 */
public abstract class AbstractMapMatrix implements MapMatrix {

	/**
	 * Constructor for AbstractMapMatrix.
	 */
	public AbstractMapMatrix() {
		super();
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return String.valueOf(baseRows);
	}

	private Map baseRows = newBaseRowsMap();

	private Map findByRow(Object row) {
		return (Map) baseRows.get(row);
	}

	abstract protected Map newRowMap();

	abstract protected Map newBaseRowsMap();

	abstract protected Map newGetColResult();

	abstract protected Map newGetRowResult(Map source);

	abstract protected Set newColKeySet();

	abstract protected Set newRowKeySet(Set source);

	private Map needByRow(Object row) {
		Map result = findByRow(row);
		if (result == null) {
			result = newRowMap();
			baseRows.put(row, result);
		}
		return result;
	}

	public Object get(Object col, Object row) {
		Map source = findByRow(row);
		if (source == null)
			return null;
		return source.get(col);
	}

	public void put(Object col, Object row, Object value) {
		Map dest = needByRow(row);
		dest.put(col, value);
	}

	public void remove(Object col, Object row) {
		Map source = findByRow(row);
		if (source == null)
			return;
		source.remove(col);
	}

	public void clear() {
		baseRows.clear();
	}

	/**
	 *  
	 */
	public Set colKeySet() {
		Set result = newColKeySet();
		Iterator iter = baseRows.keySet().iterator();
		while (iter.hasNext()) {
			Map row = (Map) baseRows.get(iter.next());
			result.addAll(row.keySet());
		}
		return result;
	}

	/**
	 *  
	 */
	public Set rowKeySet() {
		Set result = newRowKeySet(baseRows.keySet());
		return result;
	}

	/**
	 *  
	 */
	public Map getCol(Object colKey) {
		Map result = newGetColResult();
		Iterator iter = baseRows.keySet().iterator();
		while (iter.hasNext()) {
			Object rowKey = iter.next();
			Map row = (Map) baseRows.get(rowKey);
			Object val = row.get(colKey);
			if (val != null)
				result.put(rowKey, val);
		}
		return result;
	}

	/**
	 *  
	 */
	public Map getRow(Object rowKey) {
		return newGetRowResult(findByRow(rowKey));
	}
}