/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/19 14:03:29
 */
package org.asyrinx.brownie.core.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author akima
 */
public class SimpleSVParser implements SVParser {

	/**
	 *  
	 */
	public SimpleSVParser() {
		super();
	}

	private SVParserListener listener;

	private String delimeter = String.valueOf(DELIM_COMMA);

	public void parse(Reader reader) throws IOException {
		final BufferedReader bufferedReader = new BufferedReader(reader);
		String line = bufferedReader.readLine();
		final List dest = new ArrayList();
		while (line != null) {
			StringUtils.tokenize(dest, line, delimeter);
			listener.onLine(dest);
			line = bufferedReader.readLine();
			dest.clear();
		}
	}

	/**
	 * @return
	 */
	public String getDelimeter() {
		return delimeter;
	}

	/**
	 * @param string
	 */
	public void setDelimeter(String string) {
		delimeter = string;
	}

	public void addListener(SVParserListener l) {
		this.listener = l;
	}

	public void removeListener(SVParserListener l) {
		if (this.listener == l)
			this.listener = null;
	}

}