/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author Akima
 */
public abstract class AbstractFileStreamFactory implements FileStreamFactory {

	/**
	 * Constructor for AbstractFileStreamFactory.
	 */
	public AbstractFileStreamFactory() {
		super();
	}

	protected IOException keyClassMismatch(Object key) {
		return new IOException("key=[" + key
				+ "]FileNX܂StringNX̃CX^XłȂĂ͂Ȃ܂B");
	}

	protected RuntimeException keyClassMismatchRuntime(Object key) {
		return new RuntimeException("key=[" + key
				+ "]FileNX܂StringNX̃CX^XłȂĂ͂Ȃ܂B");
	}

	public String toFilePath(Object key) {
		if (key instanceof File)
			return ((File) key).getAbsolutePath();
		else if (key instanceof String)
			return toFilePath((String) key);
		else
			throw keyClassMismatchRuntime(key);
	}

	public File toFile(Object key) {
		if (key instanceof File)
			return (File) key;
		else if (key instanceof String)
			return toFile((String) key);
		else
			throw keyClassMismatchRuntime(key);
	}

	abstract public String toFilePath(String fileName);

	public final File toFile(String fileName) {
		return new File(toFilePath(fileName));
	}

	/**
	 *  
	 */
	public InputStream newInput(Object key) throws IOException {
		if (key instanceof File) {
			return newInput((File) key);
		} else if (key instanceof String) {
			return newInput((String) key);
		} else {
			throw keyClassMismatch(key);
		}
	}

	/**
	 *  
	 */
	public InputStream newInput(File file) throws IOException {
		return newInput(file.getPath());
	}

	/**
	 *  
	 */
	public OutputStream newOutput(Object key) throws IOException {
		if (key instanceof File) {
			return newOutput((File) key);
		} else if (key instanceof String) {
			return newOutput((String) key);
		} else {
			throw keyClassMismatch(key);
		}
	}

	/**
	 *  
	 */
	public OutputStream newOutput(File file) throws IOException {
		return newOutput(file.getPath());
	}
}