/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/**
 * @author Akima
 *  
 */
public final class ArrayUtils extends org.apache.commons.lang.ArrayUtils {

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1 == array2)
            return true;
        if (ObjectUtils.eitherIsNull(array1, array2))
            return false;
        if (array1.length != array2.length)
            return false;
        for (int i = 0; i < array1.length; i++) {
            if (!ObjectUtils.equals(array1[i], array2[i]))
                return false;
        }
        return true;
    }

    public static void addToList(List dest, Object[] objects) {
        for (int i = 0; i < objects.length; i++)
            dest.add(objects[i]);
    }

    public static ArrayList toArrayList(Object[] objects) {
        final ArrayList result = new ArrayList();
        addToList(result, objects);
        return result;
    }

    public static Vector toVector(Object[] objects) {
        final Vector result = new Vector();
        addToList(result, objects);
        return result;
    }

    public static Object getFirst(Object[] objects) {
        if (objects == null) {
            return null;
        } else if (objects.length == 0) {
            return null;
        } else {
            return objects[0];
        }
    }

    public static Object getLast(Object[] objects) {
        if (objects == null) {
            return null;
        } else if (objects.length == 0) {
            return null;
        } else {
            return objects[objects.length - 1];
        }
    }

    /**
     * Collection̊evfString̔zɕϊ܂B <br>
     * 
     * @param sources
     * @return String[]
     */
    public static String[] toStringArray(Collection sources) {
        final String[] result = new String[sources.size()];
        final Iterator iterator = sources.iterator();
        int idx = 0;
        while (iterator.hasNext()) {
            Object element = iterator.next();
            result[idx] = (element != null) ? element.toString() : null;
            idx++;
        }
        return result;
    }

    /**
     * Object̔z̊evfString̔zɕϊ܂B <br>
     * 
     * @param sources
     * @return String[]
     */
    public static String[] toStringArray(Object[] sources) {
        final String[] result = new String[sources.length];
        for (int idx = 0; idx < sources.length; idx++)
            result[idx] = (sources[idx] != null) ? sources[idx].toString() : null;
        return result;
    }

    public static Object[] subArray(Object[] source, int beginIdx, int length) {
        if (source == null)
            return null;
        final Object[] result = new Object[length];
        for (int i = beginIdx;; i++) {
            if (i > source.length - 1)
                break;
            if (i - beginIdx > result.length - 1)
                break;
            result[i - beginIdx] = source[i];
        }
        return result;
    }

    public static char[] toPrimitive(final Character[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        final char[] result = new char[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = array[i].charValue();
        }
        return result;
    }

    /**
     * @param array
     * @return
     */
    public static Character[] toObject(char[] array) {
        if (array == null) {
            return null;
        } else if (array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        final Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; i++) {
            result[i] = new Character(array[i]);
        }
        return result;
    }

    public static Object[] toObjectArray(Object primitiveArray) {
        if (primitiveArray instanceof boolean[]) {
            return toObject((boolean[]) primitiveArray);
        } else if (primitiveArray instanceof byte[]) {
            return toObject((byte[]) primitiveArray);
        } else if (primitiveArray instanceof short[]) {
            return toObject((short[]) primitiveArray);
        } else if (primitiveArray instanceof int[]) {
            return toObject((int[]) primitiveArray);
        } else if (primitiveArray instanceof long[]) {
            return toObject((long[]) primitiveArray);
        } else if (primitiveArray instanceof double[]) {
            return toObject((double[]) primitiveArray);
        } else if (primitiveArray instanceof float[]) {
            return toObject((float[]) primitiveArray);
        } else if (primitiveArray instanceof char[]) {
            return toObject((char[]) primitiveArray);
        }
        throw new UnsupportedClassRuntimeException(primitiveArray.getClass().getName());
    }

    public static Object toPrimitiveArray(Object[] objectArray) {
        if (objectArray instanceof Boolean[]) {
            return toPrimitive((Boolean[]) objectArray);
        } else if (objectArray instanceof Byte[]) {
            return toPrimitive((Byte[]) objectArray);
        } else if (objectArray instanceof Short[]) {
            return toPrimitive((Short[]) objectArray);
        } else if (objectArray instanceof Integer[]) {
            return toPrimitive((Integer[]) objectArray);
        } else if (objectArray instanceof Long[]) {
            return toPrimitive((Long[]) objectArray);
        } else if (objectArray instanceof Double[]) {
            return toPrimitive((Double[]) objectArray);
        } else if (objectArray instanceof Float[]) {
            return toPrimitive((Float[]) objectArray);
        } else if (objectArray instanceof Character[]) {
            return toPrimitive((Character[]) objectArray);
        }
        throw new UnsupportedClassRuntimeException(objectArray.getClass().getName());
    }

}