/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/21
 */
package org.asyrinx.brownie.core.sql;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/**
 * DynamicSQLŎgp鉉Zq\NXłB
 */
public class Operator {
	public Operator(String code) {
		super();
		this.code = code;
		operators.add(this);
	}

	final private String code;

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (obj instanceof Operator) {
			return obj == this;
		} else {
			return code.equalsIgnoreCase(String.valueOf(obj));
		}
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return code.hashCode();
	}

	public String toString() {
		return code;
	}

	private static final Set operators = new HashSet();

	/** none (null object) */
	public static final Operator NONE = new Operator("");

	/** = */
	public static final Operator EQUAL = new Operator("=");

	/** == */
	public static final Operator EQUAL2 = new Operator("==");

	/** <> */
	public static final Operator NOT_EQUAL = new Operator("<>");

	/** != */
	public static final Operator NOT_EQUAL2 = new Operator("!=");

	/** > */
	public static final Operator GREATER_THAN = new Operator(">");

	/** >= */
	public static final Operator GREATER_EQUAL = new Operator(">=");

	/** => */
	public static final Operator GREATER_EQUAL2 = new Operator("=>");

	/** < */
	public static final Operator LESS_THAN = new Operator("<");

	/** >= */
	public static final Operator LESS_EQUAL = new Operator("<=");

	/** => */
	public static final Operator LESS_EQUAL2 = new Operator("=<");

	/** like */
	public static final Operator LIKE = new Operator("like");

	/** not like */
	public static final Operator NOT_LIKE = new Operator("not like");

	/** is */
	public static final Operator IS = new Operator("is");

	/** not is */
	public static final Operator NOT_IS = new Operator("not is");

	/** in */
	public static final Operator IN = new Operator("in");

	/** not in */
	public static final Operator NOT_IN = new Operator("not in");

	/** exists */
	public static final Operator EXISTS = new Operator("exists");

	/** not exists */
	public static final Operator NOT_EXISTS = new Operator("not exists");

	/** between */
	public static final Operator BETWEEN = new Operator("between");

	/** not between */
	public static final Operator NOT_BETWEEN = new Operator("not between");

	/** and */
	public static final Operator AND = new Operator("and");

	/** or */
	public static final Operator OR = new Operator("or");

	/** xor */
	public static final Operator XOR = new Operator("xor");

	public static Operator get(Object value) {
		if (value instanceof Operator)
			return (Operator) value;
		final Iterator iterator = operators.iterator();
		while (iterator.hasNext()) {
			final Operator operator = (Operator) iterator.next();
			if (operator.equals(value))
				return operator;
		}
		return null;
	}

}