/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/25 22:24:35
 */
package org.asyrinx.brownie.core.xml.dom.impl;

import java.io.OutputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.asyrinx.brownie.core.xml.dom.DomBuilder;
import org.asyrinx.brownie.core.xml.dom.XmlBeanWriter;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author takeshi
 */
public class XmlBeanWriterImpl implements XmlBeanWriter {

    /**
     *  
     */
    public XmlBeanWriterImpl(DomBuilder domBuilder) {
        super();
        this.domBuilder = domBuilder;
    }

    protected final DomBuilder domBuilder;

    private String encoding = "Shift_JIS";

    private boolean indent = true;

    public void execute(Object bean, OutputStream domDest, String rootName) throws ParserConfigurationException,
            TransformerException {
        final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        final DocumentBuilder builder = builderFactory.newDocumentBuilder();
        final DOMImplementation domImpl = builder.getDOMImplementation();
        final Document document = domImpl.createDocument("", rootName, null);
        //
        final Element root = document.getDocumentElement();
        this.domBuilder.prepareRoot(root, bean);
        this.domBuilder.execute(document, bean, root);
        //
        final TransformerFactory transFactory = TransformerFactory.newInstance();
        final Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty(OutputKeys.ENCODING, getEncoding());
        transformer.setOutputProperty(OutputKeys.INDENT, getIndentValue());
        //
        final DOMSource source = new DOMSource(document);
        final StreamResult result = new StreamResult(domDest);
        transformer.transform(source, result);
    }

    public String getIndentValue() {
        return isIndent() ? "yes" : "no";
    }

    public String getEncoding() {
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isIndent() {
        return indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }
}