/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.logger;

import java.util.List;

import net.sf.hibernate.Criteria;
import net.sf.hibernate.FetchMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Order;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.hibernate.wrapper.CriteriaWrapper;

/**
 * @author akima
 */
public class LogCriteria extends CriteriaWrapper {

    /**
     * @param wrapped
     * @param log
     */
    public LogCriteria(Criteria wrapped, CascadeNamedLog parentLog) {
        super(wrapped);
        this.log = parentLog.subLog(wrapped);
    }

    protected final CascadeNamedLog log;

    private Criteria toLogged(Criteria criteria) {
        return new LogCriteria(criteria, log.subLog(criteria));
    }

    /**
     * @see net.sf.hibernate.Criteria#add(net.sf.hibernate.expression.Criterion)
     */
    public Criteria add(Criterion criterion) {
        log.log("add( " + criterion + " )");
        return toLogged(super.add(criterion));
    }

    /**
     * @see net.sf.hibernate.Criteria#addOrder(net.sf.hibernate.expression.Order)
     */
    public Criteria addOrder(Order order) {
        log.log("addOrder( " + order + " )");
        return toLogged(super.addOrder(order));
    }

    /**
     * @see net.sf.hibernate.Criteria#createAlias(java.lang.String,
     *      java.lang.String)
     */
    public Criteria createAlias(String associationPath, String alias) throws HibernateException {
        log.log("createAlias( " + associationPath + "," + alias + " )");
        return toLogged(super.createAlias(associationPath, alias));
    }

    /**
     * @see net.sf.hibernate.Criteria#createCriteria(java.lang.String,
     *      java.lang.String)
     */
    public Criteria createCriteria(String associationPath, String alias) throws HibernateException {
        log.log("createCriteria( " + associationPath + "," + alias + " )");
        return toLogged(super.createCriteria(associationPath, alias));
    }

    /**
     * @see net.sf.hibernate.Criteria#createCriteria(java.lang.String)
     */
    public Criteria createCriteria(String associationPath) throws HibernateException {
        log.log("createCriteria( " + associationPath + " )");
        return toLogged(super.createCriteria(associationPath));
    }

    /**
     * @see net.sf.hibernate.Criteria#getCriteriaClass()
     */
    public Class getCriteriaClass() {
        return super.getCriteriaClass();
    }

    /**
     * @see net.sf.hibernate.Criteria#getCriteriaClass(java.lang.String)
     */
    public Class getCriteriaClass(String alias) {
        return super.getCriteriaClass(alias);
    }

    /**
     * @see net.sf.hibernate.Criteria#list()
     */
    public List list() throws HibernateException {
        log.log("list()");
        return super.list();
    }

    /**
     * @see net.sf.hibernate.Criteria#returnMaps()
     * @deprecated
     */
    public Criteria returnMaps() {
        log.log("returnMaps()");
        return toLogged(super.returnMaps());
    }

    /**
     * @see net.sf.hibernate.Criteria#returnRootEntities()
     * @deprecated
     */
    public Criteria returnRootEntities() {
        log.log("returnRootEntities()");
        return toLogged(super.returnRootEntities());
    }

    /**
     * @see net.sf.hibernate.Criteria#setFetchMode(java.lang.String,
     *      net.sf.hibernate.FetchMode)
     */
    public Criteria setFetchMode(String associationPath, FetchMode mode) throws HibernateException {
        log.log("setFetchMode( " + associationPath + "," + mode + " )");
        return toLogged(super.setFetchMode(associationPath, mode));
    }

    /**
     * @see net.sf.hibernate.Criteria#setFirstResult(int)
     */
    public Criteria setFirstResult(int firstResult) {
        log.log("setFirstResult( " + firstResult + " )");
        return toLogged(super.setFirstResult(firstResult));
    }

    /**
     * @see net.sf.hibernate.Criteria#setLockMode(net.sf.hibernate.LockMode)
     */
    public Criteria setLockMode(LockMode lockMode) {
        log.log("setLockMode( " + lockMode + " )");
        return toLogged(super.setLockMode(lockMode));
    }

    /**
     * @see net.sf.hibernate.Criteria#setLockMode(java.lang.String,
     *      net.sf.hibernate.LockMode)
     */
    public Criteria setLockMode(String alias, LockMode lockMode) {
        log.log("setLockMode( " + alias + ", " + lockMode + " )");
        return toLogged(super.setLockMode(alias, lockMode));
    }

    /**
     * @see net.sf.hibernate.Criteria#setMaxResults(int)
     */
    public Criteria setMaxResults(int maxResults) {
        log.log("setMaxResults( " + maxResults + " )");
        return toLogged(super.setMaxResults(maxResults));
    }

    /**
     * @see net.sf.hibernate.Criteria#setTimeout(int)
     */
    public Criteria setTimeout(int timeout) {
        log.log("setTimeout( " + timeout + " )");
        return toLogged(super.setTimeout(timeout));
    }

    /**
     * @see net.sf.hibernate.Criteria#uniqueResult()
     */
    public Object uniqueResult() throws HibernateException {
        log.log("uniqueResult()");
        return super.uniqueResult();
    }

}