/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.logger;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.Query;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.type.Type;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.hibernate.wrapper.QueryWrapper;

/**
 * @author akima
 */
public class LogQuery extends QueryWrapper {

    /**
     * @param wrapped
     * @param log
     */
    public LogQuery(Query wrapped, CascadeNamedLog parentLog) {
        super(wrapped);
        this.log = parentLog.subLog(wrapped);
    }

    protected final CascadeNamedLog log;

    private Query toLogged(Query query) {
        return new LogQuery(query, log.subLog(query));
    }

    /**
     * @see net.sf.hibernate.Query#getNamedParameters()
     */
    public String[] getNamedParameters() throws HibernateException {
        log.log("getNamedParameters()");
        return super.getNamedParameters();
    }

    /**
     * @see net.sf.hibernate.Query#getQueryString()
     */
    public String getQueryString() {
        log.log("getQueryString()");
        return super.getQueryString();
    }

    /**
     * @see net.sf.hibernate.Query#getReturnTypes()
     */
    public Type[] getReturnTypes() throws HibernateException {
        log.log("getReturnTypes()");
        return super.getReturnTypes();
    }

    /**
     * @see net.sf.hibernate.Query#iterate()
     */
    public Iterator iterate() throws HibernateException {
        log.log("iterate()");
        return super.iterate();
    }

    /**
     * @see net.sf.hibernate.Query#list()
     */
    public List list() throws HibernateException {
        log.log("list()");
        return super.list();
    }

    /**
     * @see net.sf.hibernate.Query#scroll()
     */
    public ScrollableResults scroll() throws HibernateException {
        final ScrollableResults result = super.scroll();
        log.log("scroll()");
        return new LogScrollableResults(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Query#setBigDecimal(int, java.math.BigDecimal)
     */
    public Query setBigDecimal(int position, BigDecimal number) {
        log.log("setBigDecimal(" + position + ", " + number + ")");
        return toLogged(super.setBigDecimal(position, number));
    }

    /**
     * @see net.sf.hibernate.Query#setBigDecimal(java.lang.String,
     *      java.math.BigDecimal)
     */
    public Query setBigDecimal(String name, BigDecimal number) {
        log.log("setBigDecimal(" + name + ", " + number + ")");
        return toLogged(super.setBigDecimal(name, number));
    }

    /**
     * @see net.sf.hibernate.Query#setBinary(int, byte[])
     */
    public Query setBinary(int position, byte[] val) {
        log.log("setBinary(" + position + ", " + val + ")");
        return toLogged(super.setBinary(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setBinary(java.lang.String, byte[])
     */
    public Query setBinary(String name, byte[] val) {
        log.log("setBinary(" + name + ", " + val + ")");
        return toLogged(super.setBinary(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setBoolean(int, boolean)
     */
    public Query setBoolean(int position, boolean val) {
        log.log("setBoolean(" + position + ", " + val + ")");
        return toLogged(super.setBoolean(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setBoolean(java.lang.String, boolean)
     */
    public Query setBoolean(String name, boolean val) {
        log.log("setBoolean(" + name + ", " + val + ")");
        return toLogged(super.setBoolean(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setByte(int, byte)
     */
    public Query setByte(int position, byte val) {
        log.log("setByte(" + position + ", " + val + ")");
        return toLogged(super.setByte(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setByte(java.lang.String, byte)
     */
    public Query setByte(String name, byte val) {
        log.log("setByte(" + name + ", " + val + ")");
        return toLogged(super.setByte(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setCacheable(boolean)
     */
    public Query setCacheable(boolean cacheable) {
        log.log("setCacheable(" + cacheable + ")");
        return toLogged(super.setCacheable(cacheable));
    }

    /**
     * @see net.sf.hibernate.Query#setCacheRegion(java.lang.String)
     */
    public Query setCacheRegion(String cacheRegion) {
        log.log("setCacheRegion(" + cacheRegion + ")");
        return toLogged(super.setCacheRegion(cacheRegion));
    }

    /**
     * @see net.sf.hibernate.Query#setCalendar(int, java.util.Calendar)
     */
    public Query setCalendar(int position, Calendar calendar) {
        log.log("setCalendar(" + position + ", " + calendar + ")");
        return toLogged(super.setCalendar(position, calendar));
    }

    /**
     * @see net.sf.hibernate.Query#setCalendar(java.lang.String,
     *      java.util.Calendar)
     */
    public Query setCalendar(String name, Calendar calendar) {
        log.log("setCalendar(" + name + ", " + calendar + ")");
        return toLogged(super.setCalendar(name, calendar));
    }

    /**
     * @see net.sf.hibernate.Query#setCalendarDate(int, java.util.Calendar)
     */
    public Query setCalendarDate(int position, Calendar calendar) {
        log.log("setCalendarDate(" + position + ", " + calendar + ")");
        return toLogged(super.setCalendarDate(position, calendar));
    }

    /**
     * @see net.sf.hibernate.Query#setCalendarDate(java.lang.String,
     *      java.util.Calendar)
     */
    public Query setCalendarDate(String name, Calendar calendar) {
        log.log("setCalendarDate(" + name + ", " + calendar + ")");
        return toLogged(super.setCalendarDate(name, calendar));
    }

    /**
     * @see net.sf.hibernate.Query#setCharacter(int, char)
     */
    public Query setCharacter(int position, char val) {
        log.log("setCharacter(" + position + ", " + val + ")");
        return toLogged(super.setCharacter(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setCharacter(java.lang.String, char)
     */
    public Query setCharacter(String name, char val) {
        log.log("setCharacter(" + name + ", " + val + ")");
        return toLogged(super.setCharacter(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setDate(int, java.util.Date)
     */
    public Query setDate(int position, Date date) {
        log.log("setDate(" + position + ", " + date + ")");
        return toLogged(super.setDate(position, date));
    }

    /**
     * @see net.sf.hibernate.Query#setDate(java.lang.String, java.util.Date)
     */
    public Query setDate(String name, Date date) {
        log.log("setDate(" + name + ", " + date + ")");
        return toLogged(super.setDate(name, date));
    }

    /**
     * @see net.sf.hibernate.Query#setDouble(int, double)
     */
    public Query setDouble(int position, double val) {
        log.log("setDouble(" + position + ", " + val + ")");
        return toLogged(super.setDouble(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setDouble(java.lang.String, double)
     */
    public Query setDouble(String name, double val) {
        log.log("setDouble(" + name + ", " + val + ")");
        return toLogged(super.setDouble(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setEntity(int, java.lang.Object)
     */
    public Query setEntity(int position, Object val) {
        log.log("setEntity(" + position + ", " + val + ")");
        return toLogged(super.setEntity(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setEntity(java.lang.String, java.lang.Object)
     */
    public Query setEntity(String name, Object val) {
        log.log("setEntity(" + name + ", " + val + ")");
        return toLogged(super.setEntity(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setEnum(int, java.lang.Object)
     * @deprecated
     */
    public Query setEnum(int position, Object val) throws MappingException {
        log.log("setEnum(" + position + ", " + val + ")");
        return toLogged(super.setEnum(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setEnum(java.lang.String, java.lang.Object)
     * @deprecated
     */
    public Query setEnum(String name, Object val) throws MappingException {
        log.log("setEnum(" + name + ", " + val + ")");
        return toLogged(super.setEnum(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setFirstResult(int)
     */
    public Query setFirstResult(int firstResult) {
        log.log("setFirstResult(" + firstResult + ")");
        return toLogged(super.setFirstResult(firstResult));
    }

    /**
     * @see net.sf.hibernate.Query#setFloat(int, float)
     */
    public Query setFloat(int position, float val) {
        log.log("setFloat(" + position + ", " + val + ")");
        return toLogged(super.setFloat(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setFloat(java.lang.String, float)
     */
    public Query setFloat(String name, float val) {
        log.log("setFloat(" + name + ", " + val + ")");
        return toLogged(super.setFloat(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setInteger(int, int)
     */
    public Query setInteger(int position, int val) {
        log.log("setInteger(" + position + ", " + val + ")");
        return toLogged(super.setInteger(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setInteger(java.lang.String, int)
     */
    public Query setInteger(String name, int val) {
        log.log("setInteger(" + name + ", " + val + ")");
        return toLogged(super.setInteger(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setLocale(int, java.util.Locale)
     */
    public Query setLocale(int position, Locale locale) {
        log.log("setLocale(" + position + ", " + locale + ")");
        return toLogged(super.setLocale(position, locale));
    }

    /**
     * @see net.sf.hibernate.Query#setLocale(java.lang.String, java.util.Locale)
     */
    public Query setLocale(String name, Locale locale) {
        log.log("setLocale(" + name + ", " + locale + ")");
        return toLogged(super.setLocale(name, locale));
    }

    /**
     * @see net.sf.hibernate.Query#setLockMode(java.lang.String,
     *      net.sf.hibernate.LockMode)
     */
    public void setLockMode(String alias, LockMode lockMode) {
        log.log("setLockMode(" + alias + ", " + lockMode + ")");
        super.setLockMode(alias, lockMode);
    }

    /**
     * @see net.sf.hibernate.Query#setLong(int, long)
     */
    public Query setLong(int position, long val) {
        log.log("setLong(" + position + ", " + val + ")");
        return toLogged(super.setLong(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setLong(java.lang.String, long)
     */
    public Query setLong(String name, long val) {
        log.log("setLong(" + name + ", " + val + ")");
        return toLogged(super.setLong(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setMaxResults(int)
     */
    public Query setMaxResults(int maxResults) {
        log.log("setMaxResults(" + maxResults + ")");
        return toLogged(super.setMaxResults(maxResults));
    }

    /**
     * @see net.sf.hibernate.Query#setParameter(int, java.lang.Object,
     *      net.sf.hibernate.type.Type)
     */
    public Query setParameter(int position, Object val, Type type) {
        log.log("setParameter(" + position + ", " + val + ", " + type + ")");
        return toLogged(super.setParameter(position, val, type));
    }

    /**
     * @see net.sf.hibernate.Query#setParameter(int, java.lang.Object)
     */
    public Query setParameter(int position, Object val) throws HibernateException {
        log.log("setParameter(" + position + ", " + val + ")");
        return toLogged(super.setParameter(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setParameter(java.lang.String,
     *      java.lang.Object, net.sf.hibernate.type.Type)
     */
    public Query setParameter(String name, Object val, Type type) {
        log.log("setParameter(" + name + ", " + val + "," + type + ")");
        return toLogged(super.setParameter(name, val, type));
    }

    /**
     * @see net.sf.hibernate.Query#setParameter(java.lang.String,
     *      java.lang.Object)
     */
    public Query setParameter(String name, Object val) throws HibernateException {
        log.log("setParameter(" + name + ", " + val + ")");
        return toLogged(super.setParameter(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setParameterList(java.lang.String,
     *      java.util.Collection, net.sf.hibernate.type.Type)
     */
    public Query setParameterList(String name, Collection vals, Type type) throws HibernateException {
        log.log("setParameterList(" + name + ", " + vals + ", " + type + ")");
        return toLogged(super.setParameterList(name, vals, type));
    }

    /**
     * @see net.sf.hibernate.Query#setParameterList(java.lang.String,
     *      java.util.Collection)
     */
    public Query setParameterList(String name, Collection vals) throws HibernateException {
        log.log("setParameterList(" + name + ", " + vals + ")");
        return toLogged(super.setParameterList(name, vals));
    }

    /**
     * @see net.sf.hibernate.Query#setParameterList(java.lang.String,
     *      java.lang.Object[], net.sf.hibernate.type.Type)
     */
    public Query setParameterList(String name, Object[] vals, Type type) throws HibernateException {
        log.log("setParameterList(" + name + ", " + vals + ", " + type + ")");
        return toLogged(super.setParameterList(name, vals, type));
    }

    /**
     * @see net.sf.hibernate.Query#setParameterList(java.lang.String,
     *      java.lang.Object[])
     */
    public Query setParameterList(String name, Object[] vals) throws HibernateException {
        log.log("setParameterList(" + name + ", " + vals + ")");
        return toLogged(super.setParameterList(name, vals));
    }

    /**
     * @see net.sf.hibernate.Query#setProperties(java.lang.Object)
     */
    public Query setProperties(Object bean) throws HibernateException {
        log.log("setProperties(" + bean + ")");
        return toLogged(super.setProperties(bean));
    }

    /**
     * @see net.sf.hibernate.Query#setSerializable(int, java.io.Serializable)
     */
    public Query setSerializable(int position, Serializable val) {
        log.log("setSerializable(" + position + ", " + val + ")");
        return toLogged(super.setSerializable(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setSerializable(java.lang.String,
     *      java.io.Serializable)
     */
    public Query setSerializable(String name, Serializable val) {
        log.log("setSerializable(" + name + ", " + val + ")");
        return toLogged(super.setSerializable(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setShort(int, short)
     */
    public Query setShort(int position, short val) {
        log.log("setShort(" + position + ", " + val + ")");
        return toLogged(super.setShort(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setShort(java.lang.String, short)
     */
    public Query setShort(String name, short val) {
        log.log("setShort(" + name + ", " + val + ")");
        return toLogged(super.setShort(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setString(int, java.lang.String)
     */
    public Query setString(int position, String val) {
        log.log("setString(" + position + ", " + val + ")");
        return toLogged(super.setString(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setString(java.lang.String, java.lang.String)
     */
    public Query setString(String name, String val) {
        log.log("setString(" + name + ", " + val + ")");
        return toLogged(super.setString(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setText(int, java.lang.String)
     */
    public Query setText(int position, String val) {
        log.log("setText(" + position + ", " + val + ")");
        return toLogged(super.setText(position, val));
    }

    /**
     * @see net.sf.hibernate.Query#setText(java.lang.String, java.lang.String)
     */
    public Query setText(String name, String val) {
        log.log("setText(" + name + ", " + val + ")");
        return toLogged(super.setText(name, val));
    }

    /**
     * @see net.sf.hibernate.Query#setTime(int, java.util.Date)
     */
    public Query setTime(int position, Date date) {
        log.log("setTime(" + position + ", " + date + ")");
        return toLogged(super.setTime(position, date));
    }

    /**
     * @see net.sf.hibernate.Query#setTime(java.lang.String, java.util.Date)
     */
    public Query setTime(String name, Date date) {
        log.log("setTime(" + name + ", " + date + ")");
        return toLogged(super.setTime(name, date));
    }

    /**
     * @see net.sf.hibernate.Query#setTimeout(int)
     */
    public Query setTimeout(int timeout) {
        log.log("setTimeout(" + timeout + ")");
        return toLogged(super.setTimeout(timeout));
    }

    /**
     * @see net.sf.hibernate.Query#setTimestamp(int, java.util.Date)
     */
    public Query setTimestamp(int position, Date date) {
        log.log("setTimestamp(" + position + ", " + date + ")");
        return toLogged(super.setTimestamp(position, date));
    }

    /**
     * @see net.sf.hibernate.Query#setTimestamp(java.lang.String,
     *      java.util.Date)
     */
    public Query setTimestamp(String name, Date date) {
        log.log("setTimestamp(" + name + ", " + date + ")");
        return toLogged(super.setTimestamp(name, date));
    }

    /**
     * @see net.sf.hibernate.Query#uniqueResult()
     */
    public Object uniqueResult() throws HibernateException {
        return super.uniqueResult();
    }

}