/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.logger;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.type.Type;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.hibernate.wrapper.ScrollableResultsWrapper;

/**
 * @author akima
 */
public class LogScrollableResults extends ScrollableResultsWrapper {

	/**
	 * @param wrapped
	 * @param log
	 */
	public LogScrollableResults(ScrollableResults wrapped,
			CascadeNamedLog parentLog) {
		super(wrapped);
		this.log = parentLog.subLog(wrapped);
	}

	protected final CascadeNamedLog log;

	/**
	 * @see net.sf.hibernate.ScrollableResults#afterLast()
	 */
	public void afterLast() throws HibernateException {
		log.log("afterLast()");
		super.afterLast();
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#beforeFirst()
	 */
	public void beforeFirst() throws HibernateException {
		log.log("beforeFirst()");
		super.beforeFirst();
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#close()
	 */
	public void close() throws HibernateException {
		log.log("close()");
		super.close();
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#first()
	 */
	public boolean first() throws HibernateException {
		log.log("first()");
		return super.first();
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#get()
	 */
	public Object[] get() throws HibernateException {
		return super.get();
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#get(int)
	 */
	public Object get(int i) throws HibernateException {
		return super.get(i);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getBigDecimal(int)
	 */
	public BigDecimal getBigDecimal(int col) throws HibernateException {
		return super.getBigDecimal(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getBinary(int)
	 */
	public byte[] getBinary(int col) throws HibernateException {
		return super.getBinary(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getBlob(int)
	 */
	public Blob getBlob(int col) throws HibernateException {
		return super.getBlob(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getBoolean(int)
	 */
	public Boolean getBoolean(int col) throws HibernateException {
		return super.getBoolean(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getByte(int)
	 */
	public Byte getByte(int col) throws HibernateException {
		return super.getByte(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getCalendar(int)
	 */
	public Calendar getCalendar(int col) throws HibernateException {
		return super.getCalendar(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getCharacter(int)
	 */
	public Character getCharacter(int col) throws HibernateException {
		return super.getCharacter(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getClob(int)
	 */
	public Clob getClob(int col) throws HibernateException {
		return super.getClob(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getDate(int)
	 */
	public Date getDate(int col) throws HibernateException {
		return super.getDate(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getDouble(int)
	 */
	public Double getDouble(int col) throws HibernateException {
		return super.getDouble(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getFloat(int)
	 */
	public Float getFloat(int col) throws HibernateException {
		return super.getFloat(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getInteger(int)
	 */
	public Integer getInteger(int col) throws HibernateException {
		return super.getInteger(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getLocale(int)
	 */
	public Locale getLocale(int col) throws HibernateException {
		return super.getLocale(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getLong(int)
	 */
	public Long getLong(int col) throws HibernateException {
		return super.getLong(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getRowNumber()
	 */
	public int getRowNumber() throws HibernateException {
		return super.getRowNumber();
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getShort(int)
	 */
	public Short getShort(int col) throws HibernateException {
		return super.getShort(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getString(int)
	 */
	public String getString(int col) throws HibernateException {
		return super.getString(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getText(int)
	 */
	public String getText(int col) throws HibernateException {
		return super.getText(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getTimeZone(int)
	 */
	public TimeZone getTimeZone(int col) throws HibernateException {
		return super.getTimeZone(col);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#getType(int)
	 */
	public Type getType(int i) {
		return super.getType(i);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#isFirst()
	 */
	public boolean isFirst() throws HibernateException {
		return super.isFirst();
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#isLast()
	 */
	public boolean isLast() throws HibernateException {
		return super.isLast();
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#last()
	 */
	public boolean last() throws HibernateException {
		log.log("last()");
		return super.last();
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#next()
	 */
	public boolean next() throws HibernateException {
		log.log("next()");
		return super.next();
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#previous()
	 */
	public boolean previous() throws HibernateException {
		log.log("previous()");
		return super.previous();
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#scroll(int)
	 */
	public boolean scroll(int i) throws HibernateException {
		log.log("scroll(" + i + ")");
		return super.scroll(i);
	}

	/**
	 * @see net.sf.hibernate.ScrollableResults#setRowNumber(int)
	 */
	public boolean setRowNumber(int rowNumber) throws HibernateException {
		log.log("setRowNumber(" + rowNumber + ")");
		return super.setRowNumber(rowNumber);
	}

}