/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.wrapper;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.Query;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.type.Type;

/**
 * @author akima
 */
public class QueryWrapper implements Query {

	/**
	 *  
	 */
	public QueryWrapper(Query wrapped) {
		super();
		this.wrapped = wrapped;
	}

	protected final Query wrapped;

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public String[] getNamedParameters() throws HibernateException {
		return wrapped.getNamedParameters();
	}

	/**
	 * @return
	 */
	public String getQueryString() {
		return wrapped.getQueryString();
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Type[] getReturnTypes() throws HibernateException {
		return wrapped.getReturnTypes();
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Iterator iterate() throws HibernateException {
		return wrapped.iterate();
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public List list() throws HibernateException {
		return wrapped.list();
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public ScrollableResults scroll() throws HibernateException {
		return wrapped.scroll();
	}

	/**
	 * @param position
	 * @param number
	 * @return
	 */
	public Query setBigDecimal(int position, BigDecimal number) {
		return wrapped.setBigDecimal(position, number);
	}

	/**
	 * @param name
	 * @param number
	 * @return
	 */
	public Query setBigDecimal(String name, BigDecimal number) {
		return wrapped.setBigDecimal(name, number);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setBinary(int position, byte[] val) {
		return wrapped.setBinary(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setBinary(String name, byte[] val) {
		return wrapped.setBinary(name, val);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setBoolean(int position, boolean val) {
		return wrapped.setBoolean(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setBoolean(String name, boolean val) {
		return wrapped.setBoolean(name, val);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setByte(int position, byte val) {
		return wrapped.setByte(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setByte(String name, byte val) {
		return wrapped.setByte(name, val);
	}

	/**
	 * @param cacheable
	 * @return
	 */
	public Query setCacheable(boolean cacheable) {
		return wrapped.setCacheable(cacheable);
	}

	/**
	 * @param cacheRegion
	 * @return
	 */
	public Query setCacheRegion(String cacheRegion) {
		return wrapped.setCacheRegion(cacheRegion);
	}

	/**
	 * @param position
	 * @param calendar
	 * @return
	 */
	public Query setCalendar(int position, Calendar calendar) {
		return wrapped.setCalendar(position, calendar);
	}

	/**
	 * @param name
	 * @param calendar
	 * @return
	 */
	public Query setCalendar(String name, Calendar calendar) {
		return wrapped.setCalendar(name, calendar);
	}

	/**
	 * @param position
	 * @param calendar
	 * @return
	 */
	public Query setCalendarDate(int position, Calendar calendar) {
		return wrapped.setCalendarDate(position, calendar);
	}

	/**
	 * @param name
	 * @param calendar
	 * @return
	 */
	public Query setCalendarDate(String name, Calendar calendar) {
		return wrapped.setCalendarDate(name, calendar);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setCharacter(int position, char val) {
		return wrapped.setCharacter(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setCharacter(String name, char val) {
		return wrapped.setCharacter(name, val);
	}

	/**
	 * @param position
	 * @param date
	 * @return
	 */
	public Query setDate(int position, Date date) {
		return wrapped.setDate(position, date);
	}

	/**
	 * @param name
	 * @param date
	 * @return
	 */
	public Query setDate(String name, Date date) {
		return wrapped.setDate(name, date);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setDouble(int position, double val) {
		return wrapped.setDouble(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setDouble(String name, double val) {
		return wrapped.setDouble(name, val);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setEntity(int position, Object val) {
		return wrapped.setEntity(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setEntity(String name, Object val) {
		return wrapped.setEntity(name, val);
	}

	/**
	 * @param position
	 * @param val
	 * @return @throws
	 *         net.sf.hibernate.MappingException
	 * @deprecated
	 */
	public Query setEnum(int position, Object val) throws MappingException {
		return wrapped.setEnum(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return @throws
	 *         net.sf.hibernate.MappingException
	 * @deprecated
	 */
	public Query setEnum(String name, Object val) throws MappingException {
		return wrapped.setEnum(name, val);
	}

	/**
	 * @param firstResult
	 * @return
	 */
	public Query setFirstResult(int firstResult) {
		return wrapped.setFirstResult(firstResult);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setFloat(int position, float val) {
		return wrapped.setFloat(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setFloat(String name, float val) {
		return wrapped.setFloat(name, val);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setInteger(int position, int val) {
		return wrapped.setInteger(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setInteger(String name, int val) {
		return wrapped.setInteger(name, val);
	}

	/**
	 * @param position
	 * @param locale
	 * @return
	 */
	public Query setLocale(int position, Locale locale) {
		return wrapped.setLocale(position, locale);
	}

	/**
	 * @param name
	 * @param locale
	 * @return
	 */
	public Query setLocale(String name, Locale locale) {
		return wrapped.setLocale(name, locale);
	}

	/**
	 * @param alias
	 * @param lockMode
	 */
	public void setLockMode(String alias, LockMode lockMode) {
		wrapped.setLockMode(alias, lockMode);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setLong(int position, long val) {
		return wrapped.setLong(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setLong(String name, long val) {
		return wrapped.setLong(name, val);
	}

	/**
	 * @param maxResults
	 * @return
	 */
	public Query setMaxResults(int maxResults) {
		return wrapped.setMaxResults(maxResults);
	}

	/**
	 * @param position
	 * @param val
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Query setParameter(int position, Object val)
			throws HibernateException {
		return wrapped.setParameter(position, val);
	}

	/**
	 * @param position
	 * @param val
	 * @param type
	 * @return
	 */
	public Query setParameter(int position, Object val, Type type) {
		return wrapped.setParameter(position, val, type);
	}

	/**
	 * @param name
	 * @param val
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Query setParameter(String name, Object val)
			throws HibernateException {
		return wrapped.setParameter(name, val);
	}

	/**
	 * @param name
	 * @param val
	 * @param type
	 * @return
	 */
	public Query setParameter(String name, Object val, Type type) {
		return wrapped.setParameter(name, val, type);
	}

	/**
	 * @param name
	 * @param vals
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Query setParameterList(String name, Object[] vals)
			throws HibernateException {
		return wrapped.setParameterList(name, vals);
	}

	/**
	 * @param name
	 * @param vals
	 * @param type
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Query setParameterList(String name, Object[] vals, Type type)
			throws HibernateException {
		return wrapped.setParameterList(name, vals, type);
	}

	/**
	 * @param name
	 * @param vals
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Query setParameterList(String name, Collection vals)
			throws HibernateException {
		return wrapped.setParameterList(name, vals);
	}

	/**
	 * @param name
	 * @param vals
	 * @param type
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Query setParameterList(String name, Collection vals, Type type)
			throws HibernateException {
		return wrapped.setParameterList(name, vals, type);
	}

	/**
	 * @param bean
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Query setProperties(Object bean) throws HibernateException {
		return wrapped.setProperties(bean);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setSerializable(int position, Serializable val) {
		return wrapped.setSerializable(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setSerializable(String name, Serializable val) {
		return wrapped.setSerializable(name, val);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setShort(int position, short val) {
		return wrapped.setShort(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setShort(String name, short val) {
		return wrapped.setShort(name, val);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setString(int position, String val) {
		return wrapped.setString(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setString(String name, String val) {
		return wrapped.setString(name, val);
	}

	/**
	 * @param position
	 * @param val
	 * @return
	 */
	public Query setText(int position, String val) {
		return wrapped.setText(position, val);
	}

	/**
	 * @param name
	 * @param val
	 * @return
	 */
	public Query setText(String name, String val) {
		return wrapped.setText(name, val);
	}

	/**
	 * @param position
	 * @param date
	 * @return
	 */
	public Query setTime(int position, Date date) {
		return wrapped.setTime(position, date);
	}

	/**
	 * @param name
	 * @param date
	 * @return
	 */
	public Query setTime(String name, Date date) {
		return wrapped.setTime(name, date);
	}

	/**
	 * @param timeout
	 * @return
	 */
	public Query setTimeout(int timeout) {
		return wrapped.setTimeout(timeout);
	}

	/**
	 * @param position
	 * @param date
	 * @return
	 */
	public Query setTimestamp(int position, Date date) {
		return wrapped.setTimestamp(position, date);
	}

	/**
	 * @param name
	 * @param date
	 * @return
	 */
	public Query setTimestamp(String name, Date date) {
		return wrapped.setTimestamp(name, date);
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Object uniqueResult() throws HibernateException {
		return wrapped.uniqueResult();
	}

	/**
	 * @param arg0
	 * @return
	 */
	public Query setFetchSize(int arg0) {
		return wrapped.setFetchSize(arg0);
	}

    /**
     * @param arg0
     * @return
     */
    public Query setForceCacheRefresh(boolean arg0) {
        return wrapped.setForceCacheRefresh(arg0);
    }
}