/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.jdbc.wrapper;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

import org.asyrinx.brownie.core.util.Wrapper;

/**
 * @author Akima
 */
public class ConnectionWrapper extends Wrapper implements Connection {

	/**
	 * Constructor for ConnectionWrapper.
	 */
	public ConnectionWrapper(Connection source) {
		super(source);
		this.source = source;
	}

	protected final Connection source;

	/**
	 * Returns the source.
	 * 
	 * @return Connection
	 */
	public Connection getSource() {
		return source;
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void clearWarnings() throws SQLException {
		source.clearWarnings();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void close() throws SQLException {
		source.close();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void commit() throws SQLException {
		source.commit();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Statement createStatement() throws SQLException {
		return source.createStatement();
	}

	/**
	 * @param resultSetType
	 * @param resultSetConcurrency
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Statement createStatement(int resultSetType, int resultSetConcurrency)
			throws SQLException {
		return source.createStatement(resultSetType, resultSetConcurrency);
	}

	/**
	 * @param resultSetType
	 * @param resultSetConcurrency
	 * @param resultSetHoldability
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Statement createStatement(int resultSetType,
			int resultSetConcurrency, int resultSetHoldability)
			throws SQLException {
		return source.createStatement(resultSetType, resultSetConcurrency,
				resultSetHoldability);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean getAutoCommit() throws SQLException {
		return source.getAutoCommit();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public String getCatalog() throws SQLException {
		return source.getCatalog();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getHoldability() throws SQLException {
		return source.getHoldability();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public DatabaseMetaData getMetaData() throws SQLException {
		return source.getMetaData();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getTransactionIsolation() throws SQLException {
		return source.getTransactionIsolation();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Map getTypeMap() throws SQLException {
		return source.getTypeMap();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public SQLWarning getWarnings() throws SQLException {
		return source.getWarnings();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isClosed() throws SQLException {
		return source.isClosed();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean isReadOnly() throws SQLException {
		return source.isReadOnly();
	}

	/**
	 * @param sql
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public String nativeSQL(String sql) throws SQLException {
		return source.nativeSQL(sql);
	}

	/**
	 * @param sql
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public CallableStatement prepareCall(String sql) throws SQLException {
		return source.prepareCall(sql);
	}

	/**
	 * @param sql
	 * @param resultSetType
	 * @param resultSetConcurrency
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public CallableStatement prepareCall(String sql, int resultSetType,
			int resultSetConcurrency) throws SQLException {
		return source.prepareCall(sql, resultSetType, resultSetConcurrency);
	}

	/**
	 * @param sql
	 * @param resultSetType
	 * @param resultSetConcurrency
	 * @param resultSetHoldability
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public CallableStatement prepareCall(String sql, int resultSetType,
			int resultSetConcurrency, int resultSetHoldability)
			throws SQLException {
		return source.prepareCall(sql, resultSetType, resultSetConcurrency,
				resultSetHoldability);
	}

	/**
	 * @param sql
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public PreparedStatement prepareStatement(String sql) throws SQLException {
		return source.prepareStatement(sql);
	}

	/**
	 * @param sql
	 * @param autoGeneratedKeys
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)
			throws SQLException {
		return source.prepareStatement(sql, autoGeneratedKeys);
	}

	/**
	 * @param sql
	 * @param resultSetType
	 * @param resultSetConcurrency
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public PreparedStatement prepareStatement(String sql, int resultSetType,
			int resultSetConcurrency) throws SQLException {
		return source
				.prepareStatement(sql, resultSetType, resultSetConcurrency);
	}

	/**
	 * @param sql
	 * @param resultSetType
	 * @param resultSetConcurrency
	 * @param resultSetHoldability
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public PreparedStatement prepareStatement(String sql, int resultSetType,
			int resultSetConcurrency, int resultSetHoldability)
			throws SQLException {
		return source.prepareStatement(sql, resultSetType,
				resultSetConcurrency, resultSetHoldability);
	}

	/**
	 * @param sql
	 * @param columnIndexes
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public PreparedStatement prepareStatement(String sql, int[] columnIndexes)
			throws SQLException {
		return source.prepareStatement(sql, columnIndexes);
	}

	/**
	 * @param sql
	 * @param columnNames
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public PreparedStatement prepareStatement(String sql, String[] columnNames)
			throws SQLException {
		return source.prepareStatement(sql, columnNames);
	}

	/**
	 * @param savepoint
	 * @throws java.sql.SQLException
	 */
	public void releaseSavepoint(Savepoint savepoint) throws SQLException {
		source.releaseSavepoint(savepoint);
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void rollback() throws SQLException {
		source.rollback();
	}

	/**
	 * @param savepoint
	 * @throws java.sql.SQLException
	 */
	public void rollback(Savepoint savepoint) throws SQLException {
		source.rollback(savepoint);
	}

	/**
	 * @param autoCommit
	 * @throws java.sql.SQLException
	 */
	public void setAutoCommit(boolean autoCommit) throws SQLException {
		source.setAutoCommit(autoCommit);
	}

	/**
	 * @param catalog
	 * @throws java.sql.SQLException
	 */
	public void setCatalog(String catalog) throws SQLException {
		source.setCatalog(catalog);
	}

	/**
	 * @param holdability
	 * @throws java.sql.SQLException
	 */
	public void setHoldability(int holdability) throws SQLException {
		source.setHoldability(holdability);
	}

	/**
	 * @param readOnly
	 * @throws java.sql.SQLException
	 */
	public void setReadOnly(boolean readOnly) throws SQLException {
		source.setReadOnly(readOnly);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Savepoint setSavepoint() throws SQLException {
		return source.setSavepoint();
	}

	/**
	 * @param name
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Savepoint setSavepoint(String name) throws SQLException {
		return source.setSavepoint(name);
	}

	/**
	 * @param level
	 * @throws java.sql.SQLException
	 */
	public void setTransactionIsolation(int level) throws SQLException {
		source.setTransactionIsolation(level);
	}

	/**
	 * @param map
	 * @throws java.sql.SQLException
	 */
	public void setTypeMap(Map map) throws SQLException {
		source.setTypeMap(map);
	}

}