/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/28 15:06:09
 */
package org.asyrinx.brownie.seasar.dbcp.logger;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.core.log.DispatchLog;
import org.asyrinx.brownie.jdbc.logger.LogConnection;
import org.asyrinx.brownie.jdbc.logger.LogXAConnection;
import org.asyrinx.brownie.jdbc.logger.LogXAResource;
import org.seasar.extension.dbcp.ConnectionWrapper;

/**
 * @author takeshi
 */
public class LogConnectionWrapper extends LogConnection implements ConnectionWrapper {

    /**
     * @param wrapped
     */
    public LogConnectionWrapper(ConnectionWrapper wrapped) {
        this(wrapped, new CascadeNamedLog(wrapped.getClass(), DispatchLog.DEFAULT_LEVEL));
    }

    /**
     * @param wrapped
     */
    public LogConnectionWrapper(ConnectionWrapper wrapped, CascadeNamedLog log) {
        super(wrapped);
        this.wrapped = wrapped;
        this.log = log;
    }

    protected final CascadeNamedLog log;

    protected final ConnectionWrapper wrapped;

    public void closeReally() {
        try {
            wrapped.closeReally();
            log.log("closeReally()");
        } catch (RuntimeException e) {
            log.error("failed closeReally()", e);
            throw e;
        }
    }

    public Connection getPhysicalConnection() {
        try {
            final Connection result = wrapped.getPhysicalConnection();
            log.log("getPhysicalConnection(): " + result);
            return new LogConnection(result, log.subLog(result));
        } catch (RuntimeException e) {
            log.error("failed getPhysicalConnection()", e);
            throw e;
        }
    }

    public XAConnection getXAConnection() {
        try {
            final XAConnection result = wrapped.getXAConnection();
            log.log("getXAConnection(): " + result);
            return new LogXAConnection(result, log.subLog(result));
        } catch (RuntimeException e) {
            log.error("failed getXAConnection()", e);
            throw e;
        }
    }

    public XAResource getXAResource() {
        try {
            final XAResource result = wrapped.getXAResource();
            log.log("getXAResource(): " + result);
            return new LogXAResource(result, log.subLog(result));
        } catch (RuntimeException e) {
            log.error("failed getXAResource()", e);
            throw e;
        }
    }

    public void init() throws SQLException {
        try {
            wrapped.init();
            log.log("init()");
        } catch (SQLException e) {
            log.error("failed init()", e);
            throw e;
        }
    }

    public void release() throws SQLException {
        try {
            wrapped.release();
            log.log("release()");
        } catch (SQLException e) {
            log.error("failed release()", e);
            throw e;
        }
    }
}