/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/04/09 14:33:40
 */
package org.asyrinx.brownie.seasar.servlet;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.servlet.FileNameResolver;
import org.asyrinx.brownie.servlet.ServletContextRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.factory.S2ContainerTagHandlerRule;
import org.seasar.framework.util.SAXParserFactoryUtil;
import org.seasar.framework.xml.SaxHandler;
import org.seasar.framework.xml.SaxHandlerParser;

/**
 * @author akima
 */
public class S2ContainerLoader {

	public static final String SERVLET_CONTEXT_PARAM_INITFILE = "s2config";

	public static final String SERVLET_CONTEXT_ATTRIBUTE_CONTAINER = S2ContainerLoader.class
			.getName()
			+ ".container";

	public S2ContainerLoader(ServletContext context) {
		this.context = context;
		this.resolver = new FileNameResolver(this.context);
	}

	private final ServletContext context;

	private final FileNameResolver resolver;

	private SaxHandlerParser createSaxHandlerParser() {
		final SAXParserFactory factory = SAXParserFactoryUtil.newInstance();
		factory.setValidating(true);
		final SAXParser saxParser = SAXParserFactoryUtil.newSAXParser(factory);
		final SaxHandler handler = new SaxHandler(rule_);
		handler.registerDtdPath(S2ContainerFactory.PUBLIC_ID,
				S2ContainerFactory.DTD_PATH);
		final SaxHandlerParser parser = new SaxHandlerParser(handler, saxParser);
		return parser;
	}

	public S2Container createContainer() throws IOException {
		final SaxHandlerParser parser = createSaxHandlerParser();
		final String webContextRealPath = resolver.getContextRootPath();
		final InputStream inputStream = StreamFactoryFacade.newFacade(
				webContextRealPath).newInput(
				context.getInitParameter(SERVLET_CONTEXT_PARAM_INITFILE));
		return (S2Container) parser.parse(inputStream);
	}

	private static S2ContainerTagHandlerRule rule_ = new S2ContainerTagHandlerRule();

	private S2Container container = null;

	public void initializeContainer() {
		try {
			container = createContainer();
			this.context.setAttribute(SERVLET_CONTEXT_ATTRIBUTE_CONTAINER,
					container);
		} catch (IOException e) {
			throw new ServletContextRuntimeException(e);
		}
	}

	public void finalizeContainer() {
		container.destroy();
	}

	public static S2Container getContainer(ServletContext context) {
		return (S2Container) context
				.getAttribute(SERVLET_CONTEXT_ATTRIBUTE_CONTAINER);
	}
}