/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/04/09 14:33:52
 */
package org.asyrinx.brownie.seasar.servlet;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * @author akima
 */
public class S2ContainerLoaderListener implements ServletContextListener {

	private S2ContainerLoader contextLoader = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.ServletContextListener#contextInitialized(javax.servlet.ServletContextEvent)
	 */
	public void contextInitialized(ServletContextEvent event) {
		contextLoader = new S2ContainerLoader(event.getServletContext());
		contextLoader.initializeContainer();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.ServletContextListener#contextDestroyed(javax.servlet.ServletContextEvent)
	 */
	public void contextDestroyed(ServletContextEvent event) {
		contextLoader.finalizeContainer();
	}

}