/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/07 0:47:59
 */
package org.asyrinx.brownie.swing.table.wrapper;

import java.util.Enumeration;

import javax.swing.ListSelectionModel;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/**
 * @author akima
 */
public class TableColumnModelWrapper implements TableColumnModel {

    /**
     *  
     */
    public TableColumnModelWrapper(TableColumnModel columnModel) {
        super();
        this.columnModel = columnModel;
    }

    protected final TableColumnModel columnModel;

    /**
     * @param aColumn
     */
    public void addColumn(TableColumn aColumn) {
        columnModel.addColumn(aColumn);
    }

    /**
     * @param x
     */
    public void addColumnModelListener(TableColumnModelListener x) {
        columnModel.addColumnModelListener(x);
    }

    /**
     * @param columnIndex
     * @return
     */
    public TableColumn getColumn(int columnIndex) {
        return columnModel.getColumn(columnIndex);
    }

    /**
     * @return
     */
    public int getColumnCount() {
        return columnModel.getColumnCount();
    }

    /**
     * @param columnIdentifier
     * @return
     */
    public int getColumnIndex(Object columnIdentifier) {
        return columnModel.getColumnIndex(columnIdentifier);
    }

    /**
     * @param xPosition
     * @return
     */
    public int getColumnIndexAtX(int xPosition) {
        return columnModel.getColumnIndexAtX(xPosition);
    }

    /**
     * @return
     */
    public int getColumnMargin() {
        return columnModel.getColumnMargin();
    }

    /**
     * @return
     */
    public Enumeration getColumns() {
        return columnModel.getColumns();
    }

    /**
     * @return
     */
    public boolean getColumnSelectionAllowed() {
        return columnModel.getColumnSelectionAllowed();
    }

    /**
     * @return
     */
    public int getSelectedColumnCount() {
        return columnModel.getSelectedColumnCount();
    }

    /**
     * @return
     */
    public int[] getSelectedColumns() {
        return columnModel.getSelectedColumns();
    }

    /**
     * @return
     */
    public ListSelectionModel getSelectionModel() {
        return columnModel.getSelectionModel();
    }

    /**
     * @return
     */
    public int getTotalColumnWidth() {
        return columnModel.getTotalColumnWidth();
    }

    /**
     * @param columnIndex
     * @param newIndex
     */
    public void moveColumn(int columnIndex, int newIndex) {
        columnModel.moveColumn(columnIndex, newIndex);
    }

    /**
     * @param column
     */
    public void removeColumn(TableColumn column) {
        columnModel.removeColumn(column);
    }

    /**
     * @param x
     */
    public void removeColumnModelListener(TableColumnModelListener x) {
        columnModel.removeColumnModelListener(x);
    }

    /**
     * @param newMargin
     */
    public void setColumnMargin(int newMargin) {
        columnModel.setColumnMargin(newMargin);
    }

    /**
     * @param flag
     */
    public void setColumnSelectionAllowed(boolean flag) {
        columnModel.setColumnSelectionAllowed(flag);
    }

    /**
     * @param newModel
     */
    public void setSelectionModel(ListSelectionModel newModel) {
        columnModel.setSelectionModel(newModel);
    }
}