/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/04
 */
package test.org.asyrinx.brownie.core.collection;

import java.util.Map;
import java.util.Properties;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.collection.MapTree;

/**
 * @author akima
 */
public class MapTreeTest extends TestCase {

	/**
	 * Constructor for MapTreeTest.
	 * @param name
	 */
	public MapTreeTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(MapTreeTest.class);
	}

	public void testAdd() {
		final MapTree tree = new MapTree();
		tree.put("a.a.a", "aaa");
		tree.put("a.a.b", "aab");
		tree.put("a.a.c", "aac");
		tree.put("a.b.a", "aba");
		tree.put("a.b.b", "abb");
		tree.put("b.a.a", "baa");
		tree.put("b.a.b", "bab");
		final Map root = tree.getRoot();
		final Map a = tree.getMap("a");
		final Map b = tree.getMap("b");
		assertEquals(a, root.get("a"));
		assertEquals(b, root.get("b"));
		assertEquals(null, tree.getMap("c"));
		final Map aa = tree.getMap("a.a");
		final Map ab = tree.getMap("a.b");
		assertEquals(null, tree.getMap("a.c"));
		final Map ba = tree.getMap("b.a");
		assertEquals(null, tree.getMap("b.b"));
		assertEquals(null, tree.getMap("b.c"));
		assertEquals(aa, a.get("a"));
		assertEquals(ab, a.get("b"));
		assertEquals(null, a.get("c"));
		assertEquals(ba, b.get("a"));
		assertEquals(null, b.get("b"));
		assertEquals(null, b.get("c"));
		assertEquals("aaa", aa.get("a"));
		assertEquals("aab", aa.get("b"));
		assertEquals("aac", aa.get("c"));
		assertEquals("aba", ab.get("a"));
		assertEquals("abb", ab.get("b"));
		assertEquals(null, ab.get("c"));
		assertEquals("baa", ba.get("a"));
		assertEquals("bab", ba.get("b"));
		assertEquals(null, ba.get("c"));

		assertEquals("aaa", tree.get("a.a.a"));
		assertEquals("aab", tree.get("a.a.b"));
		assertEquals("aac", tree.get("a.a.c"));
		assertEquals("aba", tree.get("a.b.a"));
		assertEquals("abb", tree.get("a.b.b"));
		assertEquals("baa", tree.get("b.a.a"));
		assertEquals("bab", tree.get("b.a.b"));
	}

	public void testSaveToProperties() {
		final MapTree tree = new MapTree();
		tree.put("a.a.a", "aaa");
		tree.put("a.a.b", "aab");
		tree.put("a.a.c", "aac");
		tree.put("a.b.a", "aba");
		tree.put("a.b.b", "abb");
		tree.put("b.a.a", "baa");
		tree.put("b.a.b", "bab");
		final Properties properties = new Properties();
		tree.saveTo(properties);
		assertEquals("aaa", properties.getProperty("a.a.a"));
		assertEquals("aab", properties.getProperty("a.a.b"));
		assertEquals("aac", properties.getProperty("a.a.c"));
		assertEquals("aba", properties.getProperty("a.b.a"));
		assertEquals("abb", properties.getProperty("a.b.b"));
		assertEquals("baa", properties.getProperty("b.a.a"));
		assertEquals("bab", properties.getProperty("b.a.b"));
	}

	public void testLoadFromProperties() {
		final Properties properties = new Properties();
		properties.put("a.b.c", "abc");
		properties.put("a.b.d", "abd");
		properties.put("a.c.d", "acd");
		properties.put("b.a.a", "baa");
		properties.put("b.b.a", "bba");
		final MapTree tree = new MapTree();
		tree.loadFrom(properties);
		assertEquals("abc", tree.get("a.b.c"));
		assertEquals("abd", tree.get("a.b.d"));
		assertEquals("acd", tree.get("a.c.d"));
		assertEquals("baa", tree.get("b.a.a"));
		assertEquals("bba", tree.get("b.b.a"));
	}

}
