/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/15
 */
package test.org.asyrinx.brownie.core.io.sf;

import java.io.IOException;
import java.io.InputStream;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.io.TextFile;
import org.asyrinx.brownie.core.io.sf.ClassResourceStreamFactory;

/**
 * @author akima
 */
public class ClassResourceStreamFactoryTest extends TestCase {

	/**
	 * Constructor for ClassResourceStreamFactoryTest.
	 * @param name
	 */
	public ClassResourceStreamFactoryTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(ClassResourceStreamFactoryTest.class);
	}

	/*
	 * Test for InputStream newInput(String)
	 */
	public void testNewInputString() {
		org.asyrinx.brownie.core.io.sf.ClassResourceStreamFactory factory = new ClassResourceStreamFactory();
		try {
			final TextFile textFile =
				new TextFile("test/org/asyrinx/brownie/core/io/sf/ClassResourceStreamFactoryTest_01.txt");
			final InputStream inputStream = factory.newInput(textFile);
			textFile.load(inputStream);
			assertEquals("0123456789", textFile.getText());
		} catch (IOException e) {
			e.printStackTrace();
			fail();
		}

	}

}
