/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 5:08:55
 */
package org.asyrinx.joey.gen.command.rdb;

import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.joey.gen.model.Element;

/**
 * @author akima
 */
public class CheckName extends RdbCommand {

    /**
     *  
     */
    public CheckName() {
        super();
    }

    protected void check(Element element, String maxLengthProp) {
        final Object maxLength = element.getOption(maxLengthProp);
        if (maxLength == null)
            return;
        check(element, NumberUtils.toInt(maxLength, -1));
    }

    protected void check(Element element, int maxLength) {
        if (maxLength < 0)
            return;
        final String name = element.getName();
        if (name.length() > maxLength)
            addError(element, "name is too long");
    }

}