/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/08 14:53:31
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.Iterator;

import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.PrimaryKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public class PreparePrimaryKey extends RdbCommand {

    /**
     *  
     */
    public PreparePrimaryKey() {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorMock#visit(org.asyrinx.joey.gen.model.rdb.Table)
     */
    public void visit(Table table) {
        for (Iterator i = table.getColumns().iterator(); i.hasNext();) {
            final Column column = (Column) i.next();
            if (column.isPrimaryKey())
                new PrimaryKeyEntry(table.getPrimaryKey(), column);
        }
    }
}