/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/27 2:44:46
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.HashMap;
import java.util.Map;

import org.asyrinx.joey.gen.model.java.Type;
import org.asyrinx.joey.gen.model.java.classes.JavaLangClass;
import org.asyrinx.joey.gen.model.java.classes.JavaUtilClass;
import org.asyrinx.joey.gen.model.java.classes.PrimitiveType;
import org.asyrinx.joey.gen.model.rdb.Column;

/**
 * @author takeshi
 */
public class BasicTypeMapping implements TypeMappingStrategy {

    private final Map typeMap;

    /**
     *  
     */
    public BasicTypeMapping() {
        super();
        typeMap = initialize();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.TypeMappingStrategy#toJavaType(org.asyrinx.joey.gen.model.rdb.Column)
     */
    public Type toJavaType(Column column) {
        if ("CHAR".equals(column.getType()) && (column.getSizeAsInt() > 1))
            return JavaLangClass.STRING;
        else
            return (Type) typeMap.get(column.getType());
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.TypeMappingStrategy#toJavaType(java.lang.String)
     */
    public Type toJavaType(String jdbcTypeName) {
        return (Type) typeMap.get(jdbcTypeName);
    }

    /*
     * @see java.sql.Types
     */
    //public final static int BIT = -7;
    //public final static int TINYINT = -6;
    //public final static int SMALLINT = 5;
    //public final static int INTEGER = 4;
    //public final static int BIGINT = -5;
    //public final static int FLOAT = 6;
    //public final static int REAL = 7;
    //public final static int DOUBLE = 8;
    //public final static int NUMERIC = 2;
    //public final static int DECIMAL = 3;
    //public final static int CHAR = 1;
    //public final static int VARCHAR = 12;
    //public final static int LONGVARCHAR = -1;
    //public final static int DATE = 91;
    //public final static int TIME = 92;
    //public final static int TIMESTAMP = 93;
    //public final static int BINARY = -2;
    //public final static int VARBINARY = -3;
    //public final static int LONGVARBINARY = -4;
    //public final static int NULL = 0;
    //public final static int OTHER = 1111;
    //public final static int JAVA_OBJECT = 2000;
    //public final static int DISTINCT = 2001;
    //public final static int STRUCT = 2002;
    //public final static int ARRAY = 2003;
    //public final static int BLOB = 2004;
    //public final static int CLOB = 2005;
    //public final static int REF = 2006;
    //public final static int DATALINK = 70;
    //public final static int BOOLEAN = 16;
    /**
     * @param jdbcTypeName
     * @param type
     */
    private static void add(Map dest, String jdbcTypeName, Type type) {
        dest.put(jdbcTypeName, type);
    }

    /**
     *  
     */
    private static Map initialize() {
        final Map result = new HashMap();
        add(result, "BIT", PrimitiveType.BOOLEAN);
        add(result, "TINYINT", PrimitiveType.BYTE);
        add(result, "SMALLINT", PrimitiveType.SHORT);
        add(result, "INTEGER", PrimitiveType.INT);
        add(result, "BIGINT", PrimitiveType.LONG);
        add(result, "FLOAT", PrimitiveType.FLOAT);
        add(result, "REAL", PrimitiveType.DOUBLE);
        add(result, "DOUBLE", PrimitiveType.DOUBLE);
        add(result, "NUMERIC", PrimitiveType.INT);
        add(result, "DECIMAL", PrimitiveType.DOUBLE);
        add(result, "CHAR", PrimitiveType.CHAR);
        add(result, "VARCHAR", JavaLangClass.STRING);
        add(result, "LONGVARCHAR", JavaLangClass.STRING);
        add(result, "DATE", JavaUtilClass.DATE);
        add(result, "TIME", JavaUtilClass.DATE);
        add(result, "TIMESTAMP", JavaUtilClass.DATE);
        add(result, "CLOB", JavaLangClass.STRING);
        add(result, "BOOLEAN", PrimitiveType.BOOLEAN);
        return result;
    }

}