/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/12 23:23:19
 */
package org.asyrinx.joey.gen.model.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.joey.gen.model.Element;

/**
 * @author akima
 */
public class AppDomain extends Element {

    /**
     *  
     */
    public AppDomain() {
        super();
    }

    /**
     *  
     */
    public AppDomain(String name) {
        super(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#add(org.asyrinx.joey.gen.model.Element)
     */
    public void add(Element element) {
        if (element instanceof Entity)
            classes.add((Entity) element);
        else if (element instanceof JavaEnumeration)
            enumerations.add((JavaEnumeration) element);
        else
            super.add(element);
    }

    private final EntitySet classes = new EntitySet(this);

    private final JavaEnumerationSet enumerations = new JavaEnumerationSet(this);

    /**
     * @return Returns the classes.
     */
    public EntitySet getClasses() {
        return classes;
    }

    /**
     * @return Returns the enumerations.
     */
    public JavaEnumerationSet getEnumerations() {
        return enumerations;
    }

    /**
     * @param property
     * @return
     */
    public List getReferencesContainedAsForeign(Property property) {
        final List result = new ArrayList();
        for (Iterator i = getClasses().iterator(); i.hasNext();) {
            final Entity javaClass = (Entity) i.next();
            for (Iterator j = javaClass.getReferences().iterator(); j.hasNext();) {
                final Reference reference = (Reference) j.next();
                if (reference.containsAsForeign(property))
                    result.add(reference);
            }
        }
        return result;
    }

    /**
     * @param class1
     * @return
     */
    public List getReferencesContainedAsForeign(Entity javaClass) {
        final List result = new ArrayList();
        for (Iterator i = this.getClasses().iterator(); i.hasNext();) {
            final Entity class1 = (Entity) i.next();
            class1.findReferencesContainedAsForeign(javaClass, result);
        }
        return result;
    }

    /**
     * @param parent
     * @return
     */
    public List getReferencesContainedAsLocal(Entity javaClass) {
        final List result = new ArrayList();
        for (Iterator i = this.getClasses().iterator(); i.hasNext();) {
            final Entity class1 = (Entity) i.next();
            class1.findReferencesContainedAsLocal(javaClass, result);
        }
        return result;
    }
}