/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/10 16:59:05
 */
package org.asyrinx.joey.gen.model.rdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.joey.gen.model.Element;

/**
 * @author akima
 */
public class Table extends Element {

    /**
     *  
     */
    public Table() {
        super();
    }

    /**
     *  
     */
    public Table(String name) {
        this(null, name, null);
    }

    /**
     *  
     */
    public Table(String name, String label) {
        this(null, name, label);
    }

    /**
     *  
     */
    public Table(Database parent, String name) {
        this(parent, name, null);
    }

    /**
     *  
     */
    public Table(Database parent, String name, String label) {
        super(parent, name, label);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#getParentElement()
     */
    public Database getParent() {
        return (Database) super.getParentElement();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#add(org.asyrinx.joey.gen.model.Element)
     */
    public void add(Element element) {
        if (element instanceof Column)
            columns.add((Column) element);
        else if (element instanceof Unique)
            uniques.add((Unique) element);
        else if (element instanceof Index)
            indexes.add((Index) element);
        else if (element instanceof ForeignKey)
            foreignKeys.add((ForeignKey) element);
        else
            super.add(element);
    }

    private final ColumnSet columns = new ColumnSet(this);

    private final IndexSet indexes = new IndexSet(this);

    private final IndexSet uniques = new IndexSet(this);

    private final ForeignKeySet foreignKeys = new ForeignKeySet(this);

    private final PrimaryKey primaryKey = new PrimaryKey(this, "pk");

    private String _extends = null;

    private final List referrers = new ArrayList();

    public List getReferrers() {
        return referrers;
    }

    /**
     * @return Returns the columns.
     */
    public ColumnSet getColumns() {
        return columns;
    }

    /**
     * @return Returns the foreignKeys.
     */
    public ForeignKeySet getForeignKeys() {
        return foreignKeys;
    }

    /**
     * @return Returns the indexes.
     */
    public IndexSet getIndexes() {
        return indexes;
    }

    /**
     * @return Returns the uniques.
     */
    public IndexSet getUniques() {
        return uniques;
    }

    public ForeignKey findForeignKey(Index index) {
        for (final Iterator iterator = getForeignKeys().iterator(); iterator.hasNext();) {
            final ForeignKey foreignKey = (ForeignKey) iterator.next();
            if (foreignKey.getIndex() == index)
                return foreignKey;
        }
        return null;
    }

    public Iterator getPkColumns() {
        final List result = new ArrayList();
        for (final Iterator i = columns.iterator(); i.hasNext();) {
            final Column column = (Column) i.next();
            if (column.isPrimaryKey())
                result.add(column);
        }
        return Collections.unmodifiableList(result).iterator();
    }

    public boolean hasPrimaryKey() {
        for (final Iterator i = columns.iterator(); i.hasNext();) {
            final Column column = (Column) i.next();
            if (column.isPrimaryKey())
                return true;
        }
        return false;
    }

    protected final Table getTable(String name) {
        final Database database = getParent();
        if (database == null)
            return null;
        return database.getTables().getTable(name);
    }

    public Table getExtendsTable() {
        return getTable(getExtends());
    }

    /**
     * @return Returns the _extends.
     */
    public String getExtends() {
        return _extends;
    }

    /**
     * @param _extends
     *            The _extends to set.
     */
    public void setExtends(String extendz) {
        this._extends = extendz;
    }

    /**
     * @return Returns the primaryKey.
     */
    public PrimaryKey getPrimaryKey() {
        return primaryKey;
    }

}