/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/15 14:50:06
 */
package org.asyrinx.joey.gen.model.rdb.visitor;

import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.PrimaryKey;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.RdbVisitor;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.Unique;

/**
 * @author akima
 */
public class RdbVisitorWrapper implements RdbVisitor {

    /**
     *  
     */
    public RdbVisitorWrapper(RdbVisitor rdbVisitor) {
        super();
        this.rdbVisitor = rdbVisitor;
    }

    protected final RdbVisitor rdbVisitor;

    /**
     * @param column
     */
    public void visit(Column column) {
        rdbVisitor.visit(column);
    }

    /**
     * @param database
     */
    public void visit(Database database) {
        rdbVisitor.visit(database);
    }

    /**
     * @param databases
     */
    public void visit(Databases databases) {
        rdbVisitor.visit(databases);
    }

    /**
     * @param enumeration
     */
    public void visit(RdbEnumeration enumeration) {
        rdbVisitor.visit(enumeration);
    }

    /**
     * @param enumerationEntry
     */
    public void visit(EnumerationEntry enumerationEntry) {
        rdbVisitor.visit(enumerationEntry);
    }

    /**
     * @param foreignKey
     */
    public void visit(ForeignKey foreignKey) {
        rdbVisitor.visit(foreignKey);
    }

    /**
     * @param foreignKeyEntry
     */
    public void visit(ForeignKeyEntry foreignKeyEntry) {
        rdbVisitor.visit(foreignKeyEntry);
    }

    /**
     * @param index
     */
    public void visit(Index index) {
        rdbVisitor.visit(index);
    }

    /**
     * @param indexEntry
     */
    public void visit(IndexEntry indexEntry) {
        rdbVisitor.visit(indexEntry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.PrimaryKey)
     */
    public void visit(PrimaryKey primaryKey) {
        rdbVisitor.visit(primaryKey);
    }

    /**
     * @param table
     */
    public void visit(Table table) {
        rdbVisitor.visit(table);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Unique)
     */
    public void visit(Unique unique) {
        rdbVisitor.visit(unique);
    }

}