/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.csv;

public class SVTokenizer {
    private String line;
    private char delim;
    private char quote;
    private int current;
    private int max;

    public SVTokenizer(String line, char delim, char quote) {
        this.line = line;
        this.delim = delim;
        this.quote = quote;
        this.current = 0;
        this.max = line.length();
    }

    public boolean hasMoreTokens() {
        return this.nextDelim(this.current) <= this.max;
    }

    public String nextToken() {
        int work = this.current;
        this.current = this.nextDelim(this.current);
        StringBuffer buffer = new StringBuffer();
        while (work < this.current) {
            char ch;
            if ((ch = this.line.charAt(work++)) == this.quote) continue;
            buffer.append(ch);
        }
        ++this.current;
        return new String(buffer);
    }

    private int nextDelim(int position) {
        boolean inquote = false;
        while (position < this.max) {
            char ch = this.line.charAt(position);
            if (ch == this.quote) {
                inquote = !inquote;
            } else if (!inquote && ch == this.delim) break;
            ++position;
        }
        return position;
    }
}

