/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.brownie.core.io.sf.ClassResourceStreamFactory;
import org.asyrinx.brownie.core.io.sf.DirectoryBaseFileStreamFactory;
import org.asyrinx.brownie.core.io.sf.RelativeClassResourceStreamFactory;
import org.asyrinx.brownie.core.io.sf.SimpleFileStreamFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactory;
import org.asyrinx.brownie.core.io.sf.ZipEntryFileStreamFactory;

public class StreamFactoryFacade
implements StreamFactory {
    private final List factories = new ArrayList();
    static /* synthetic */ Class class$0;

    public StreamFactoryFacade copy() {
        StreamFactoryFacade result = new StreamFactoryFacade();
        result.factories.addAll(this.factories);
        return result;
    }

    public InputStream newInput(Object key) throws IOException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StreamFactory factory = (StreamFactory)iterator.next();
            try {
                InputStream result = factory.newInput(key);
                if (result == null) continue;
                return result;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new IOException("no StreamFactory for \"" + key + "\"");
    }

    public OutputStream newOutput(Object key) throws IOException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StreamFactory factory = (StreamFactory)iterator.next();
            try {
                OutputStream result = factory.newOutput(key);
                if (result == null) continue;
                return result;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new IOException("no StreamFactory for \"" + key + "\"");
    }

    public static StreamFactoryFacade newFacade() {
        return StreamFactoryFacade.newFacade((Iterator)IteratorUtils.EMPTY_ITERATOR);
    }

    public static StreamFactoryFacade newFacade(String filenames) {
        return StreamFactoryFacade.newFacade(FileNameUtils.parseFileNames(filenames));
    }

    public static StreamFactoryFacade newFacade(Collection filenames) {
        return StreamFactoryFacade.newFacade(filenames.iterator());
    }

    public static StreamFactoryFacade newFacade(Iterator filenameIterator) {
        StreamFactoryFacade result = new StreamFactoryFacade();
        result.add(new ClassResourceStreamFactory());
        result.add(new SimpleFileStreamFactory());
        while (filenameIterator.hasNext()) {
            File path = FileNameUtils.toFile(filenameIterator.next());
            if (path.isDirectory()) {
                result.add(new DirectoryBaseFileStreamFactory(path.getAbsolutePath()));
                continue;
            }
            if (FileNameUtils.hasZipExtension(path.getPath())) {
                result.add(new ZipEntryFileStreamFactory(path.getPath()));
                continue;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.asyrinx.brownie.core.io.sf.StreamFactoryFacade");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log log = LogFactory.getLog((Class)clazz);
            log.warn((Object)("path\"" + path.getPath() + "\" was not found."));
        }
        return result;
    }

    public StreamFactoryFacade addRelativeClassResourceSF() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.asyrinx.brownie.core.io.sf.StreamFactoryFacade");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.add(new RelativeClassResourceStreamFactory(clazz.getName()));
        return this;
    }

    public void add(int index, StreamFactory element) {
        this.factories.add(index, element);
    }

    public boolean add(StreamFactory o) {
        return this.factories.add(o);
    }

    public void clear() {
        this.factories.clear();
    }

    public boolean contains(StreamFactory o) {
        return this.factories.contains(o);
    }

    public StreamFactory get(int index) {
        return (StreamFactory)this.factories.get(index);
    }

    public int indexOf(StreamFactory o) {
        return this.factories.indexOf(o);
    }

    public boolean isEmpty() {
        return this.factories.isEmpty();
    }

    public Iterator iterator() {
        return this.factories.iterator();
    }

    public StreamFactory remove(int index) {
        return (StreamFactory)this.factories.remove(index);
    }

    public boolean remove(StreamFactory o) {
        return this.factories.remove(o);
    }

    public int size() {
        return this.factories.size();
    }
}

