/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.brownie.core.io.sf.DirectoryBaseFileStreamFactory;

public class ZipEntryFileStreamFactory
extends DirectoryBaseFileStreamFactory {
    private final File zipFile;
    private ZipFile targetZip = null;

    public ZipEntryFileStreamFactory(String zipFilePath) {
        this(zipFilePath, "");
    }

    public ZipEntryFileStreamFactory(File zipFile) {
        this(zipFile, "");
    }

    public ZipEntryFileStreamFactory(String zipFilePath, String baseDirectory) {
        this(new File(zipFilePath), baseDirectory);
    }

    public ZipEntryFileStreamFactory(File zipFile, String baseDirectory) {
        super(baseDirectory);
        this.zipFile = zipFile;
    }

    protected void initZipFile() throws IOException {
        if (this.targetZip != null) {
            return;
        }
        this.targetZip = new ZipFile(this.zipFile);
    }

    public String toZipEntryName(String fileName) {
        return fileName;
    }

    public String toFilePath(String virtualFileName) {
        return FileNameUtils.addSeparatorHead(super.toFilePath(virtualFileName));
    }

    public InputStream newInput(String fileName) throws IOException {
        this.initZipFile();
        String path = this.toFilePath(fileName);
        ZipEntry entry = new ZipEntry(path);
        InputStream result = this.targetZip.getInputStream(entry);
        if (result == null) {
            throw new IOException("\u30b9\u30c8\u30ea\u30fc\u30e0[" + fileName + "]\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        return result;
    }

    public OutputStream newOutput(String fileName) throws IOException {
        return null;
    }
}

