/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.util;

import java.util.Locale;
import org.asyrinx.brownie.core.util.DateRange;
import org.asyrinx.brownie.core.util.SimpleDate;
import org.asyrinx.brownie.core.util.SimpleDateRange;

public final class Era {
    private final Locale locale;
    private final SimpleDateRange range;
    private final String firstLetter;
    private final String caption;
    private final String captionShort;

    public Era(Locale locale, String caption, String captionShort, String firstLetter, SimpleDateRange range) {
        this.locale = locale;
        this.firstLetter = firstLetter;
        this.caption = caption;
        this.captionShort = captionShort;
        this.range = range;
    }

    public Era(Locale locale, String caption, String captionShort, String firstLetter, DateRange range) {
        this(locale, caption, captionShort, firstLetter, new SimpleDateRange(range));
    }

    public Era(Locale locale, String caption, String captionShort, String firstLetter, SimpleDate begin, SimpleDate end) {
        this(locale, caption, captionShort, firstLetter, new SimpleDateRange(begin, end));
    }

    public Era(Locale locale, String caption, String captionShort, String firstLetter, int beginYear, int beginMonth, int beginDay, int endYear, int endMonth, int endDay) {
        this(locale, caption, captionShort, firstLetter, new SimpleDateRange(beginYear, beginMonth, beginDay, endYear, endMonth, endDay));
    }

    public String toString() {
        return String.valueOf(this.caption) + "(" + this.range + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Era) {
            return obj == this;
        }
        if (obj instanceof String) {
            return this.matchCaptions((String)obj);
        }
        return super.equals(obj);
    }

    public boolean matchCaptions(String str) {
        return str.equals(this.caption) || str.equals(this.captionShort) || str.equals(this.firstLetter);
    }

    public String getFirstLetter() {
        return this.firstLetter;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getCaptionShort() {
        return this.captionShort;
    }

    public SimpleDateRange getRange() {
        return this.range;
    }

    public SimpleDate getBeginDate() {
        return this.range.getFrom();
    }

    public SimpleDate getEndDate() {
        return this.range.getTo();
    }

    public int getBeginDay() {
        return this.getRange().getFromDay();
    }

    public int getBeginMonth() {
        return this.getRange().getFromMonth();
    }

    public int getBeginYear() {
        return this.getRange().getFromYear();
    }

    public int getEndDay() {
        return this.getRange().getToDay();
    }

    public int getEndMonth() {
        return this.getRange().getToMonth();
    }

    public int getEndYear() {
        return this.getRange().getToYear();
    }

    public int toAnnoDomini(int eraYear) {
        return this.getBeginYear() + eraYear - 1;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getYearAt(SimpleDate d) {
        return d.getYear() - this.getBeginYear() + 1;
    }
}

