/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.xml.dom.impl;

import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.asyrinx.brownie.core.util.jp.JpDateFormat;
import org.asyrinx.brownie.core.xml.dom.DomBuilder;
import org.asyrinx.brownie.core.xml.dom.RenderingAttribute;
import org.asyrinx.brownie.core.xml.dom.RenderingDuplicated;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractDomBuilder
implements DomBuilder {
    private DateFormat dateFormat = new JpDateFormat("yyyy/MM/dd HH:mm:ss");
    protected Document document = null;
    private RenderingDuplicated renderingDuplicated;
    private RenderingAttribute renderingAttribute;

    public AbstractDomBuilder() {
        this(null, null);
    }

    public AbstractDomBuilder(RenderingDuplicated renderingDuplicated, RenderingAttribute renderingAttribute) {
        this.renderingDuplicated = renderingDuplicated != null ? renderingDuplicated : RenderingDuplicated.TAKE_FIRST;
        this.renderingAttribute = renderingAttribute != null ? renderingAttribute : RenderingAttribute.NULL;
    }

    public void prepareRoot(Element root, Object bean) {
        this.getRenderingDuplicated().clear();
    }

    public void execute(Document document, Object bean, Element element) {
        this.document = document;
        this.execute(bean, element);
    }

    protected void execute(Object bean, Element element) {
        Map properties;
        try {
            properties = PropertyUtils.describe((Object)bean);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            Object value;
            Object key = i.next();
            if (key == null || "class".equals(key) || (value = properties.get(key)) == null) continue;
            this.renderToElement(element, key, value);
        }
    }

    protected abstract void renderToElement(Element var1, Object var2, Object var3);

    protected String toString(Object value) {
        if (value instanceof Date) {
            return this.dateFormat.format((Date)value);
        }
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        return String.valueOf(value);
    }

    public RenderingDuplicated getRenderingDuplicated() {
        return this.renderingDuplicated;
    }

    public void setRenderingDuplicated(RenderingDuplicated renderingDuplicated) {
        this.renderingDuplicated = renderingDuplicated;
    }

    public RenderingAttribute getRenderingAttribute() {
        return this.renderingAttribute;
    }

    public void setRenderingAttribute(RenderingAttribute renderingAttribute) {
        this.renderingAttribute = renderingAttribute;
    }
}

