/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Table;

public class CheckForeignKey
extends RdbCommand {
    public void visit(ForeignKey foreignKey) {
        Table foreignTable;
        if (StringUtils.isEmpty((String)foreignKey.getForeign())) {
            this.addError(foreignKey, "foreignKey requires foreignTable");
        }
        if ((foreignTable = foreignKey.getForeignTable()) == null) {
            this.addError(foreignKey, "table '" + foreignKey.getForeign() + "' not found");
        }
    }

    public void visit(ForeignKeyEntry entry) {
        if (StringUtils.isEmpty((String)entry.getLocal())) {
            this.addError(entry, "foreignKeyEntry requires local");
        }
        if (StringUtils.isEmpty((String)entry.getForeign())) {
            this.addError(entry, "foreignKeyEntry requires foreign");
        }
        ForeignKey foreignKey = entry.getParent();
        if (entry.getLocalColumn() == null) {
            this.addError(entry, "column '" + entry.getLocal() + "' not found in table '" + foreignKey.getLocal().getFullName() + "'");
        }
        if (entry.getForeignColumn() == null) {
            this.addError(entry, "column '" + entry.getForeign() + "' not found in table '" + foreignKey.getForeignTable().getFullName() + "'");
        }
    }
}

