/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.HashMap;
import java.util.Map;
import org.asyrinx.joey.gen.command.rdb2java.standard.TypeMappingStrategy;
import org.asyrinx.joey.gen.model.java.Type;
import org.asyrinx.joey.gen.model.java.classes.JavaLangClass;
import org.asyrinx.joey.gen.model.java.classes.JavaUtilClass;
import org.asyrinx.joey.gen.model.java.classes.PrimitiveType;
import org.asyrinx.joey.gen.model.rdb.Column;

public class BasicTypeMapping
implements TypeMappingStrategy {
    private final Map typeMap = BasicTypeMapping.initialize();

    public Type toJavaType(Column column) {
        if ("CHAR".equals(column.getType()) && column.getSizeAsInt() > 1) {
            return JavaLangClass.STRING;
        }
        return (Type)this.typeMap.get(column.getType());
    }

    public Type toJavaType(String jdbcTypeName) {
        return (Type)this.typeMap.get(jdbcTypeName);
    }

    private static void add(Map dest, String jdbcTypeName, Type type) {
        dest.put(jdbcTypeName, type);
    }

    private static Map initialize() {
        HashMap result = new HashMap();
        BasicTypeMapping.add(result, "BIT", PrimitiveType.BOOLEAN);
        BasicTypeMapping.add(result, "TINYINT", PrimitiveType.BYTE);
        BasicTypeMapping.add(result, "SMALLINT", PrimitiveType.SHORT);
        BasicTypeMapping.add(result, "INTEGER", PrimitiveType.INT);
        BasicTypeMapping.add(result, "BIGINT", PrimitiveType.LONG);
        BasicTypeMapping.add(result, "FLOAT", PrimitiveType.FLOAT);
        BasicTypeMapping.add(result, "REAL", PrimitiveType.DOUBLE);
        BasicTypeMapping.add(result, "DOUBLE", PrimitiveType.DOUBLE);
        BasicTypeMapping.add(result, "NUMERIC", PrimitiveType.INT);
        BasicTypeMapping.add(result, "DECIMAL", PrimitiveType.DOUBLE);
        BasicTypeMapping.add(result, "CHAR", PrimitiveType.CHAR);
        BasicTypeMapping.add(result, "VARCHAR", JavaLangClass.STRING);
        BasicTypeMapping.add(result, "LONGVARCHAR", JavaLangClass.STRING);
        BasicTypeMapping.add(result, "DATE", JavaUtilClass.DATE);
        BasicTypeMapping.add(result, "TIME", JavaUtilClass.DATE);
        BasicTypeMapping.add(result, "TIMESTAMP", JavaUtilClass.DATE);
        BasicTypeMapping.add(result, "CLOB", JavaLangClass.STRING);
        BasicTypeMapping.add(result, "BOOLEAN", PrimitiveType.BOOLEAN);
        return result;
    }
}

