/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.java.EntityKey;
import org.asyrinx.joey.gen.model.java.EntityKeySet;
import org.asyrinx.joey.gen.model.java.PackageType;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.PropertySet;
import org.asyrinx.joey.gen.model.java.Reference;
import org.asyrinx.joey.gen.model.java.ReferenceSet;
import org.asyrinx.joey.gen.model.java.Type;
import org.asyrinx.joey.gen.model.java.TypeCategory;

public class Entity
extends Element
implements Type {
    private final PropertySet properties = new PropertySet(this);
    private final EntityKeySet keys = new EntityKeySet(this);
    private final ReferenceSet references = new ReferenceSet(this);
    private final Set imports = new HashSet();
    private String packageTemplate = null;
    private final Map packageNames = new HashMap();
    private String superClassName = null;
    private Entity superClass = null;

    public Entity() {
    }

    public Entity(AppDomain parent) {
        super(parent);
    }

    public Entity(String name) {
        super(name);
    }

    public Entity(AppDomain parent, String name) {
        super(parent, name);
    }

    public Entity(Element parent, String name, String label) {
        super(parent, name, label);
    }

    public AppDomain getParent() {
        return (AppDomain)super.getParentElement();
    }

    public String getFqn() {
        return String.valueOf(this.getPackage()) + "." + this.getName();
    }

    public String getPackage() {
        return this.getPackageName();
    }

    public boolean isPrimitive() {
        return false;
    }

    public Type toClass() {
        return this;
    }

    public Type toPrimitive() {
        return null;
    }

    public TypeCategory getCategory() {
        return TypeCategory.OTHERS;
    }

    public boolean isNumber() {
        return this.getCategory() == TypeCategory.NUMBER;
    }

    public void add(Element element) {
        if (element instanceof Property) {
            this.properties.add((Property)element);
        } else if (element instanceof Reference) {
            this.references.add((Reference)element);
        } else if (element instanceof EntityKey) {
            this.keys.add((EntityKey)element);
        } else {
            super.add(element);
        }
    }

    public String getPackageTemplate() {
        return this.packageTemplate;
    }

    public void setPackageTemplate(String packageTemplate) {
        this.packageTemplate = packageTemplate;
    }

    public String getPackageName() {
        return this.getPackage(PackageType.ENTITY.getName());
    }

    public void setPackageName(String packageName) {
        this.setPackage(PackageType.ENTITY.getName(), packageName);
    }

    public String getPackage(String packageType) {
        return (String)this.packageNames.get(packageType);
    }

    public void setPackage(String type, String value) {
        this.packageNames.put(type, value);
    }

    public PropertySet getProperties() {
        return this.properties;
    }

    public EntityKeySet getKeys() {
        return this.keys;
    }

    public ReferenceSet getReferences() {
        return this.references;
    }

    public EntityKey getPrimaryKey() {
        return this.keys.getPrimaryKey();
    }

    public List getReferencesContainedAsLocal(Property property) {
        return this.getReferences().getReferencesContainedAsLocal(property);
    }

    public List getReferencesContainedAsForeign(Entity javaClass) {
        return this.getReferences().getReferencesContainedAsForeign(javaClass);
    }

    public List getReferencesContainedAsForeign(Property property) {
        return this.getParent().getReferencesContainedAsForeign(property);
    }

    public List getReferreds() {
        return this.getParent().getReferencesContainedAsForeign(this);
    }

    public void findReferencesContainedAsForeign(Entity javaClass, List dest) {
        this.getReferences().findReferencesContainedAsForeign(javaClass, dest);
    }

    public void findReferencesContainedAsLocal(Entity javaClass, List dest) {
        this.getReferences().findReferencesContainedAsLocal(javaClass, dest);
    }

    public Set getImports() {
        return this.imports;
    }

    public Entity getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(Entity superClass) {
        this.superClass = superClass;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public List getPropertiesExtended() {
        if (this.getSuperClass() == null) {
            return new ArrayList();
        }
        ArrayList result = new ArrayList(this.getSuperClass().getPropertiesExtended());
        result.addAll(this.getSuperClass().getProperties().toList());
        return result;
    }

    public List getPropertiesAll() {
        List result = this.getPropertiesExtended();
        result.addAll(this.getProperties().toList());
        return result;
    }
}

