package org.asyrinx.joey.gen.sample1.dao.hibernate;

import java.io.Serializable;
import java.util.List;

import org.asyrinx.brownie.core.query.BasicSelectBuilder;
import org.asyrinx.brownie.core.query.Select;
import org.asyrinx.brownie.core.query.SelectBuilder;
import org.asyrinx.brownie.core.query.StatementType;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.seasar.hibernate.S2SessionFactory;

import org.asyrinx.joey.gen.sample1.dao.*;
import org.asyrinx.joey.gen.sample1.entity.*;


/** 
 *
 * [Tue Nov 30 21:03:20 JST 2004]
 */
public class PartyRelationTypeDaoImpl implements PartyRelationTypeDao {

	/**
	 * 
	 */
	public PartyRelationTypeDaoImpl(S2SessionFactory sessionFactory) {
		super();
		this.sessionFactory = sessionFactory;
	}

    protected final S2SessionFactory sessionFactory;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.sample1.dao.PartyRelationTypeDao#delete(org.asyrinx.joey.gen.sample1.entity.PartyRelationType)
     */
    public void delete(PartyRelationType obj) {
        sessionFactory.getSession().delete(obj);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.sample1.dao.PartyRelationTypeDao#save(org.asyrinx.joey.gen.sample1.entity.PartyRelationType)
     */
    public void save(PartyRelationType obj) {
        sessionFactory.getSession().saveOrUpdate(obj);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.sample1.dao.PartyRelationTypeDao#load(java.io.Serializable)
     */
    public PartyRelationType load(Serializable key) {
        if (key == null)
            return null;
        return (PartyRelationType) sessionFactory.getSession().load(PartyRelationType.class, key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.sample1.dao.PartyRelationTypeDao#select(org.asyrinx.brownie.core.query.exp.IExpression)
     */
    public List select(IExpression expression) {
        final Select select = new Select();
        select.getWhere().add(expression);
        final SelectBuilder builder = new BasicSelectBuilder(StatementType.HQL);
        return sessionFactory.getSession().find(builder.buildSelect(select));
    }

}
