/*
 * joey and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/31 7:33:07
 */
package org.asyrinx.joey.om.agent.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.collections.Closure;
import org.asyrinx.brownie.core.collection.MapTree;
import org.asyrinx.brownie.core.collection.MapTreeVisitor;
import org.asyrinx.joey.om.agent.AgentAssociation;

/**
 * @author akima
 */
public class AgentAssociationImpl implements AgentAssociation {

	/**
	 * 
	 */
	public AgentAssociationImpl() {
		super();
	}

	private final Set usingAgent = new HashSet();

	/* (non-Javadoc)
	 * @see org.asyrinx.joey.om.agent.AgentAssociation#addUsingAgent(java.lang.Class)
	 */
	public void addUsingAgent(Class agentClass) {
		usingAgent.add(agentClass);
	}

	/* (non-Javadoc)
	 * @see org.asyrinx.joey.om.agent.AgentAssociation#canUseAgent(java.lang.Object)
	 */
	public boolean canUseAgent(Object agent) {
		for (Iterator iter = usingAgent.iterator(); iter.hasNext();) {
			final Class class1 = (Class) iter.next();
			if (class1.isInstance(agent))
				return true;
		}
		return false;
	}

	private MapTree loadedObjects = new MapTree();

	/* (non-Javadoc)
	 * @see org.asyrinx.joey.om.agent.AgentAssociation#addLoaded(java.io.Serializable, java.lang.Object)
	 */
	public void addLoaded(Serializable key, Object entity) {
		loadedObjects.put(new Object[] { entity.getClass(), key }, entity);
	}

	/* (non-Javadoc)
	 * @see org.asyrinx.joey.om.agent.AgentAssociation#isLoaded(java.lang.Object)
	 */
	public boolean isLoaded(final Object entity) {
		if (entity == null)
			return false;
		final CheckContains checkContains = new CheckContains(entity);
		new MapTreeVisitor(loadedObjects.getRoot(), checkContains).execute();
		return checkContains.contains;
	}

	/* (non-Javadoc)
	 * @see org.asyrinx.joey.om.agent.AgentAssociation#isLoaded(java.io.Serializable, java.lang.Class)
	 */
	public boolean isLoaded(Serializable key, Class entityClass) {
		return loadedObjects.get(new Object[] { entityClass, key }) != null;
	}

	/* (non-Javadoc)
	 * @see org.asyrinx.joey.om.agent.AgentAssociation#getLoaded(java.io.Serializable, java.lang.Class)
	 */
	public Object getLoaded(Serializable key, Class entityClass) {
		return loadedObjects.get(new Object[] { entityClass, key });
	}

	/* (non-Javadoc)
	 * @see org.asyrinx.joey.om.agent.AgentAssociation#clearLoaded()
	 */
	public void clearLoaded() {
		loadedObjects.getRoot().clear();
	}

}
class CheckContains implements Closure {
	public CheckContains(Object target) {
		this.target = target;
	}
	private final Object target;
	public boolean contains = false;
	public void execute(Object object) {
		if (target == object)
			contains = true;
	}

}