/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/19 17:04:18
 */
package org.asyrinx.joey.om.condition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author takeshi
 */
public class Composite implements IConditionComposite {

    /**
     *  
     */
    public Composite() {
        super();
    }

    /**
     *  
     */
    public Composite(String operator) {
        super();
    }

    private String operator;

    /**
     * @return Returns the operator.
     */
    public String getOperator() {
        return operator;
    }

    protected final List children = new ArrayList();

    /**
     * @param operator
     *            The operator to set.
     */
    public void setOperator(String operator) {
        this.operator = operator;
    }

    /**
     * @param o
     * @return
     */
    public boolean add(ICondition o) {
        return children.add(o);
    }

    /**
     * 
     * @param fieldName
     * @param value
     * @return
     */
    public ICondition add(String fieldName, Object value) {
        final ICondition result = new Expression(fieldName, ICondition.EQUAL, value);
        return (this.add(result)) ? result : null;
    }

    /**
     * 
     * @param fieldName
     * @param operator
     * @param value
     * @return
     */
    public ICondition add(String fieldName, String operator, Object value) {
        final ICondition result = new Expression(fieldName, operator, value);
        return (this.add(result)) ? result : null;
    }

    /**
     *  
     */
    public void clear() {
        children.clear();
    }

    /**
     * @param o
     * @return
     */
    public boolean contains(ICondition o) {
        return children.contains(o);
    }

    /**
     * @param index
     * @return
     */
    public ICondition get(int index) {
        return (ICondition) children.get(index);
    }

    /**
     * @param o
     * @return
     */
    public int indexOf(ICondition o) {
        return children.indexOf(o);
    }

    /**
     * @return
     */
    public boolean isEmpty() {
        return children.isEmpty();
    }

    /**
     * @return
     */
    public Iterator iterator() {
        return children.iterator();
    }

    /**
     * @param o
     * @return
     */
    public boolean remove(ICondition o) {
        return children.remove(o);
    }

    /**
     * @return
     */
    public int size() {
        return children.size();
    }

}