/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.om.hibernate;

import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;

public abstract class AbstractHibernateTranslator {
    private boolean usePropertyInCondition = false;
    protected final Map columnToProperty;
    protected final Map tableToClass;
    protected final Log log = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public AbstractHibernateTranslator(Map columnToProperty, Map tableToClass) {
        this.columnToProperty = columnToProperty;
        this.tableToClass = tableToClass;
    }

    public AbstractHibernateTranslator(Map columnToProperty, Map tableToClass, boolean usePropertyInCondition) {
        this.columnToProperty = columnToProperty;
        this.tableToClass = tableToClass;
        this.usePropertyInCondition = usePropertyInCondition;
    }

    protected String toClass(String tableName) {
        String result = String.valueOf(this.tableToClass.get(tableName));
        return StringUtils.isEmpty((String)result) ? tableName : result;
    }

    protected String toFieldName(String columnName) {
        if (this.isUsePropertyInCondition()) {
            String result = String.valueOf(this.columnToProperty.get(columnName));
            return StringUtils.isEmpty((String)result) ? columnName : result;
        }
        int idx = columnName.indexOf(46);
        return idx > -1 ? columnName.substring(idx + 1) : columnName;
    }

    public boolean isUsePropertyInCondition() {
        return this.usePropertyInCondition;
    }

    public void setUsePropertyInCondition(boolean b) {
        this.usePropertyInCondition = b;
    }

    protected final Object toNumber(Object value, Class numberClass) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value.getClass().isArray()) {
            Class<?> clazz;
            if (value.getClass().getComponentType().isPrimitive()) {
                value = ArrayUtils.toObjectArray((Object)value);
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Number");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(value.getClass().getComponentType())) {
                return value;
            }
            Object[] objects = value;
            Object[] result = new Object[objects.length];
            int i = 0;
            while (i < objects.length) {
                result[i] = this.toNumber(objects[i], numberClass);
                ++i;
            }
            return result;
        }
        if (value instanceof Collection) {
            AbstractCollection result = value instanceof Set ? new HashSet() : new ArrayList();
            Iterator iterator = ((Collection)value).iterator();
            while (iterator.hasNext()) {
                result.add(this.toNumber(iterator.next(), numberClass));
            }
            return result;
        }
        if (value instanceof String) {
            String strValue = (String)value;
            if (StringUtils.isEmpty((String)strValue)) {
                return null;
            }
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (numberClass == clazz) {
                return new Byte(strValue);
            }
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.Short");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (numberClass == clazz2) {
                return new Short(strValue);
            }
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (numberClass == clazz3) {
                return new Integer(strValue);
            }
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (numberClass == clazz4) {
                return new Long(strValue);
            }
            Class<?> clazz5 = class$5;
            if (clazz5 == null) {
                try {
                    clazz5 = class$5 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (numberClass == clazz5) {
                return new BigInteger(strValue);
            }
            Class<?> clazz6 = class$6;
            if (clazz6 == null) {
                try {
                    clazz6 = class$6 = Class.forName("java.lang.Float");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (numberClass == clazz6) {
                return new Float(strValue);
            }
            Class<?> clazz7 = class$7;
            if (clazz7 == null) {
                try {
                    clazz7 = class$7 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (numberClass == clazz7) {
                return new Double(strValue);
            }
            return new Long(strValue);
        }
        throw new UnsupportedClassRuntimeException("cannot convert to Number: " + value.getClass().getName());
    }
}

