/*
 * joey-test and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/25 1:11:38
 */
package org.asyrinx.joey.test.dao;

import java.sql.Connection;

import javax.sql.DataSource;

import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.DataSourceUtil;

/**
 * DBUnit̃eXgP[XS2TestCasẽRei֌WDBڑ̋@\teXgP[XłB
 * 
 * @author akima
 */
public abstract class DBTestCase extends S2TestCaseBase {

    private static final String DATASOURCE_NAME = "j2ee" + ContainerConstants.NS_SEP + "dataSource";

    private DataSource dataSource_;

    public DBTestCase(String name) {
        super(name);
    }

    public DataSource getDataSource() {
        if (dataSource_ == null) {
            throw new EmptyRuntimeException("dataSource");
        }
        return dataSource_;
    }

    public Connection getConnection() {
        return DataSourceUtil.getConnection(getDataSource());
    }

    private void setupDataSource() {
        try {
            if (container_.hasComponentDef(DataSource.class)) {
                dataSource_ = (DataSource) container_.getComponent(DataSource.class);
            } else if (container_.hasComponentDef(DATASOURCE_NAME)) {
                dataSource_ = (DataSource) container_.getComponent(DATASOURCE_NAME);
            }
        } catch (Throwable t) {
            System.err.println(t);
        }
    }

    /* (non-Javadoc)
     * @see org.asyrinx.joey.test.dao.S2TestCaseBase#executeRunBare()
     */
    protected void executeRunBare() throws Throwable {
        setupDataSource();
        super.executeRunBare();
    }

    /*
     * *********************************************************************
     * from DatabaseTestCase of DBUnit
     * *********************************************************************
     */


    /**
     * Returns the test dataset.
     */
    protected abstract IDataSet getDataSet() throws Exception;

    /**
     * Returns the test database connection.
     */
    protected IDatabaseConnection getDBUnitConnection() throws Exception {
        return new DatabaseConnection(getConnection());
    }

    /**
     * Close the specified connection. Ovverride this method of you want to keep
     * your connection alive between tests.
     */
    protected void closeConnection(IDatabaseConnection connection) throws Exception {
        connection.close();
    }

    /**
     * Returns the database operation executed in test setup.
     */
    protected DatabaseOperation getSetUpOperation() throws Exception {
        return DatabaseOperation.CLEAN_INSERT;
    }

    /**
     * Returns the database operation executed in test cleanup.
     */
    protected DatabaseOperation getTearDownOperation() throws Exception {
        return DatabaseOperation.NONE;
    }

    private void executeOperation(DatabaseOperation operation) throws Exception {
        if (operation != DatabaseOperation.NONE) {
            IDatabaseConnection connection = getDBUnitConnection();
            try {
                operation.execute(connection, getDataSet());
            } finally {
                closeConnection(connection);
            }
        }
    }

    protected void setUp() throws Exception {
        executeOperation(getSetUpOperation());
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        executeOperation(getTearDownOperation());
    }

}