/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.asyrinx.brownie.core.collection.ArrayMapTreeKey;
import org.asyrinx.brownie.core.collection.MapTreeKey;
import org.asyrinx.brownie.core.collection.MapTreeVisitor;
import org.asyrinx.brownie.core.collection.NullMapTreeKey;
import org.asyrinx.brownie.core.collection.StringMapTreeKey;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;

public class MapTree {
    protected final Map root;
    protected String keyDelimiter = ".";

    public MapTree() {
        this(new HashMap());
    }

    public MapTree(Map root) {
        this.root = root;
    }

    public MapTree(MapTree mapTree) {
        this(mapTree.getRoot());
    }

    protected Object[] toKeys(Object key) {
        String keyStr = String.valueOf(key);
        return StringUtils.tokenizeToArray(keyStr, this.keyDelimiter);
    }

    protected MapTreeKey toKey(Object key) {
        if (key == null) {
            return NullMapTreeKey.getInstance();
        }
        if (key instanceof Object[]) {
            return new ArrayMapTreeKey((Object[])key);
        }
        return new StringMapTreeKey(String.valueOf(key), this.keyDelimiter);
    }

    public Object get(Object key) {
        return this.get(this.toKey(key));
    }

    public Object get(MapTreeKey key) {
        return this.get(key.getKeyArray());
    }

    public Object get(Object[] keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        Map map = keys.length == 1 ? this.root : this.getMap(ArrayUtils.subArray(keys, 0, keys.length - 1));
        return map == null ? null : map.get(keys[keys.length - 1]);
    }

    public void put(Object key, Object value) {
        this.put(this.toKey(key), value);
    }

    public void put(MapTreeKey key, Object value) {
        this.put(key.getKeyArray(), value);
    }

    public void put(Object[] keys, Object value) {
        if (keys == null || keys.length == 0) {
            return;
        }
        Map map = keys.length == 1 ? this.root : this.needMap(ArrayUtils.subArray(keys, 0, keys.length - 1));
        map.put(keys[keys.length - 1], value);
    }

    public Map getRoot() {
        return this.root;
    }

    public Map getMap(Object key) {
        if (key instanceof Object[]) {
            return this.getMap((Object[])key);
        }
        return this.getMap(this.toKeys(key));
    }

    protected Map getMap(Object[] keys) {
        Map current = this.root;
        int i = 0;
        while (i < keys.length) {
            Object val = current.get(keys[i]);
            if (!(val instanceof Map)) {
                return null;
            }
            current = (Map)val;
            ++i;
        }
        return current;
    }

    protected Map needMap(Object[] keys) {
        Map current = this.root;
        int i = 0;
        while (i < keys.length) {
            Object val = current.get(keys[i]);
            if (val instanceof Map) {
                current = (Map)val;
            } else {
                Map newMap = this.createMap();
                current.put(keys[i], newMap);
                current = newMap;
            }
            ++i;
        }
        return current;
    }

    protected Map createMap() {
        return new HashMap();
    }

    public String getKeyDelimiter() {
        return this.keyDelimiter;
    }

    public void setKeyDelimiter(String string) {
        this.keyDelimiter = string;
    }

    public void saveTo(Properties properties) {
        final Properties props = properties;
        MapTreeVisitor visitor = new MapTreeVisitor(this.root){

            public void doOnLeaf(Object value) {
                String key = StringUtils.join((Iterator)this.keyStack.iterator(), (String)MapTree.this.keyDelimiter);
                props.put(key, value);
            }
        };
        visitor.execute();
    }

    public void loadFrom(Properties properties) {
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            this.put(key, properties.get(key));
        }
    }
}

