/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.util.Iterator;
import java.util.Properties;
import org.asyrinx.brownie.core.collection.maptree.MapTree;
import org.asyrinx.brownie.core.collection.maptree.MapTreeKey;
import org.asyrinx.brownie.core.collection.maptree.MapTreeKeyFactory;
import org.asyrinx.brownie.core.collection.maptree.MapTreeVisitor;
import org.asyrinx.brownie.core.lang.StringUtils;

public class StringMapTreeKeyFactory
implements MapTreeKeyFactory,
MapTree.PropertiesAccessibleSupport {
    protected String stringKeyDelimiter = ".";

    public MapTreeKey createKey(Object object) {
        return new MapTreeKey.Default(this.toArray(String.valueOf(object)));
    }

    public void saveToProperties(MapTree mapTree, Properties dest) {
        final Properties prop = dest;
        MapTreeVisitor visitor = new MapTreeVisitor(mapTree.getRoot()){

            public void doOnLeaf(Object value) {
                String key = StringUtils.join((Iterator)this.keyStack.iterator(), (String)StringMapTreeKeyFactory.this.stringKeyDelimiter);
                prop.put(key, value);
            }
        };
        visitor.execute();
    }

    public void loadFromProperties(MapTree mapTree, Properties source) {
        Iterator<Object> iterator = source.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            mapTree.put(this.createKey(key), source.get(key));
        }
    }

    public String getStringKeyDelimiter() {
        return this.stringKeyDelimiter;
    }

    public void setStringKeyDelimiter(String stringKeyDelimiter) {
        this.stringKeyDelimiter = stringKeyDelimiter;
    }

    private Object[] toArray(String keyString) {
        String keyStr = String.valueOf(keyString);
        return StringUtils.tokenizeToArray(keyStr, this.stringKeyDelimiter);
    }
}

