/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.asyrinx.brownie.core.io.PathPointer;
import org.asyrinx.brownie.core.io.sf.ClassResourceStreamFactory;
import org.asyrinx.brownie.core.lang.InvocationInfo;
import org.asyrinx.brownie.core.lang.StringUtils;

public class RelativeClassResourceStreamFactory
extends ClassResourceStreamFactory {
    private final String classToBeCalled;
    static /* synthetic */ Class class$0;

    public RelativeClassResourceStreamFactory() {
        this(null, null);
    }

    public RelativeClassResourceStreamFactory(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public RelativeClassResourceStreamFactory(String classToBeCalled) {
        this(null, classToBeCalled);
    }

    public RelativeClassResourceStreamFactory(ClassLoader classLoader, String classToBeCalled) {
        super(classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader());
        String string;
        if (StringUtils.isEmpty((String)classToBeCalled)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.asyrinx.brownie.core.io.sf.RelativeClassResourceStreamFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            string = clazz.getName();
        } else {
            string = classToBeCalled;
        }
        this.classToBeCalled = string;
    }

    public InputStream newInput(Object key) throws IOException {
        if (key instanceof File) {
            return this.newInput((File)key);
        }
        if (key instanceof String) {
            return this.newInput((String)key);
        }
        throw this.keyClassMismatch(key);
    }

    public InputStream newInput(File file) throws IOException {
        return this.newInput(file.getPath());
    }

    public InputStream newInput(String fileName) throws IOException {
        return super.newInput(this.toFilePath(fileName));
    }

    public String toFilePath(String fileName) {
        InvocationInfo invocationInfo = new InvocationInfo(this.classToBeCalled);
        String resPath = StringUtils.replace((String)invocationInfo.getClassName(), (String)".", (String)"/");
        PathPointer pointer = new PathPointer(resPath);
        pointer.goUp();
        pointer.moveTo(fileName);
        String realPath = pointer.getPath();
        return realPath;
    }

    public String getClassToBeCalled() {
        return this.classToBeCalled;
    }
}

