/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.asyrinx.brownie.core.lang.StringUtils;

public class ClassUtils {
    public static final char PACKAGE_DELIM_CHAR = '.';
    public static final String PACKAGE_DELIM = ".";
    static /* synthetic */ Class class$0;

    public static Object newObject(String className, ClassLoader classLoader, Class baseClass) throws InstantiationException {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (className == null) {
            throw new InstantiationException("className is null !");
        }
        try {
            Class<?> resultClass = classLoader.loadClass(className);
            return ClassUtils.newObject(resultClass, baseClass);
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException(e.toString());
        }
    }

    public static Object newObject(String className, Class baseClass) throws InstantiationException {
        if (className == null) {
            throw new InstantiationException("className is null !");
        }
        try {
            Class<?> resultClass = Class.forName(className);
            return ClassUtils.newObject(resultClass, baseClass);
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException(e.toString());
        }
    }

    public static Object newObject(Class instanciateClass, Class baseClass) throws InstantiationException {
        ClassUtils.checkByBaseClass(instanciateClass, baseClass);
        try {
            return instanciateClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException(e.toString());
        }
    }

    public static Object newObject(Class instanciateClass, Class baseClass, Object[] params) throws InstantiationException {
        ClassUtils.checkByBaseClass(instanciateClass, baseClass);
        Constructor constructor = ClassUtils.findConstructor(instanciateClass, params);
        if (constructor == null) {
            throw new InstantiationException("\u8a72\u5f53\u3059\u308b\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        try {
            return constructor.newInstance(params);
        }
        catch (InstantiationException e) {
            throw new InstantiationException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InstantiationException(e.toString());
        }
    }

    public static Object newObject(String className, ClassLoader classLoader, Class baseClass, Object[] params) throws InstantiationException {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (className == null) {
            throw new InstantiationException("className is null !");
        }
        try {
            Class<?> resultClass = classLoader.loadClass(className);
            return ClassUtils.newObject(resultClass, baseClass, params);
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException(e.toString());
        }
    }

    public static Constructor findConstructor(Class targetClass, Object[] params) {
        Constructor<?>[] constructors = targetClass.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            if (ClassUtils.matchTypes(params, constructors[i].getParameterTypes())) {
                return constructors[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean matchTypes(Object[] values, Class[] valueTypes) {
        if (values == null) {
            return valueTypes == null || valueTypes.length == 0;
        }
        if (valueTypes == null) {
            return false;
        }
        if (values.length != valueTypes.length) {
            return false;
        }
        int i = 0;
        while (i < values.length) {
            if (!valueTypes[i].isInstance(values[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static List modifierToString(int value) {
        ArrayList<String> result = new ArrayList<String>();
        if (Modifier.isAbstract(value)) {
            result.add("abstract");
        }
        if (Modifier.isFinal(value)) {
            result.add("final");
        }
        if (Modifier.isInterface(value)) {
            result.add("interface");
        }
        if (Modifier.isNative(value)) {
            result.add("native");
        }
        if (Modifier.isPrivate(value)) {
            result.add("private");
        }
        if (Modifier.isProtected(value)) {
            result.add("protected");
        }
        if (Modifier.isPublic(value)) {
            result.add("public");
        }
        if (Modifier.isStatic(value)) {
            result.add("static");
        }
        if (Modifier.isStrict(value)) {
            result.add("strict");
        }
        if (Modifier.isSynchronized(value)) {
            result.add("synchronized");
        }
        if (Modifier.isTransient(value)) {
            result.add("transient");
        }
        if (Modifier.isVolatile(value)) {
            result.add("volatile");
        }
        return result;
    }

    private static void checkByBaseClass(Class targetClass, Class baseClass) throws InstantiationException {
        if (baseClass == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            baseClass = clazz;
        }
        if (!baseClass.isAssignableFrom(targetClass)) {
            throw new InstantiationException(String.valueOf(targetClass.getName()) + "\u30af\u30e9\u30b9\u306f" + baseClass.getName() + "\u30af\u30e9\u30b9\u3068\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093");
        }
    }

    public static boolean isAssignableFrom(Class target, String className) {
        if (className == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (className.equals(target.getName())) {
            return true;
        }
        Class<?>[] intf = target.getInterfaces();
        int idx = 0;
        while (idx < intf.length) {
            if (ClassUtils.isAssignableFrom(intf[idx], className)) {
                return true;
            }
            ++idx;
        }
        return ClassUtils.isAssignableFrom(target.getSuperclass(), className);
    }

    public static void showClassLoaders() {
        ClassUtils.showClassLoaders(Thread.currentThread().getContextClassLoader());
    }

    public static void showClassLoaders(Class clazz) {
        ClassUtils.showClassLoaders(clazz.getClassLoader());
    }

    public static void showClassLoaders(ClassLoader loader) {
        if (loader == null) {
            return;
        }
        int depth = ClassUtils.getClassLoaderDepth(loader);
        ClassLoader target = loader;
        while (target != null) {
            System.out.println(String.valueOf(depth) + ": " + target);
            --depth;
            target = target.getParent();
        }
    }

    public static int getClassLoaderDepth(ClassLoader loader) {
        int result = 0;
        while (loader != null) {
            ++result;
            loader = loader.getParent();
        }
        return result;
    }

    public static boolean isAncestor(ClassLoader ancestor, ClassLoader target) {
        if (target == null && ancestor == null) {
            return true;
        }
        if (target == null) {
            return false;
        }
        if (target == ancestor) {
            return true;
        }
        return ClassUtils.isAncestor(ancestor, target.getParent());
    }

    public static String toShortClassName(Class class1) {
        if (class1 == null) {
            return null;
        }
        return ClassUtils.toShortClassName(class1.getName());
    }

    public static String toShortClassName(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return null;
        }
        List elements = StringUtils.tokenize(className, PACKAGE_DELIM);
        if (elements == null) {
            return null;
        }
        if (elements.isEmpty()) {
            return null;
        }
        return String.valueOf(elements.get(elements.size() - 1));
    }
}

