/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.log;

import org.apache.commons.logging.Log;
import org.asyrinx.brownie.core.log.LogLevel;
import org.asyrinx.brownie.core.util.Wrapper;

public class LogWrapper
extends Wrapper
implements Log {
    protected final Log impl;

    public LogWrapper(Log impl) {
        super(impl);
        this.impl = impl;
    }

    public boolean isDebugEnabled() {
        return this.impl.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.impl.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.impl.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.impl.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.impl.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.impl.isWarnEnabled();
    }

    public void log(LogLevel level, Object message) {
        this.log(level, message, null);
    }

    public void log(LogLevel level, Object message, Throwable t) {
        if (this.impl == null) {
            return;
        }
        if (level == null) {
            level = LogLevel.DEBUG;
        }
        if (level == LogLevel.FATAL) {
            this.impl.fatal(message, t);
        } else if (level == LogLevel.ERROR) {
            this.impl.error(message, t);
        } else if (level == LogLevel.WARN) {
            this.impl.warn(message, t);
        } else if (level == LogLevel.INFO) {
            this.impl.info(message, t);
        } else if (level == LogLevel.DEBUG) {
            this.impl.debug(message, t);
        } else if (level == LogLevel.TRACE) {
            this.impl.trace(message, t);
        }
    }

    public void trace(Object message) {
        this.impl.trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.impl.trace(message, t);
    }

    public void debug(Object message) {
        this.impl.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.impl.debug(message, t);
    }

    public void info(Object message) {
        this.impl.info(message);
    }

    public void info(Object message, Throwable t) {
        this.impl.info(message, t);
    }

    public void warn(Object message) {
        this.impl.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.impl.warn(message, t);
    }

    public void error(Object message) {
        this.impl.error(message);
    }

    public void error(Object message, Throwable t) {
        this.impl.error(message, t);
    }

    public void fatal(Object message) {
        this.impl.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.impl.fatal(message, t);
    }
}

