/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.query;

import java.util.Iterator;
import org.asyrinx.brownie.core.query.exp.CompositeExpression;
import org.asyrinx.brownie.core.query.exp.FieldCompare;
import org.asyrinx.brownie.core.query.exp.FieldExpression;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.brownie.core.query.exp.IFieldCompare;
import org.asyrinx.brownie.core.query.exp.IFieldValuedExpression;
import org.asyrinx.brownie.core.query.model.FieldAlias;
import org.asyrinx.brownie.core.query.model.FieldAliasList;
import org.asyrinx.brownie.core.query.model.TableAlias;
import org.asyrinx.brownie.core.query.model.TableAliasList;

public class Select
implements Cloneable {
    private final FieldAliasList fields = new SelectFieldAliasList(this);
    private final TableAliasList froms = new TableAliasList();
    private final CompositeExpression where = new SelectComposite(this, "and");
    private final FieldAliasList groupBys = new SelectFieldAliasList(this);
    private final CompositeExpression havings = new SelectComposite(this, "and");
    private final FieldAliasList orderBys = new SelectFieldAliasList(this);

    protected void addFrom(TableAlias tableAlias) {
        if (this.getFroms().indexOf(tableAlias) > -1) {
            return;
        }
        this.getFroms().add(tableAlias);
    }

    public FieldAliasList getFields() {
        return this.fields;
    }

    public TableAliasList getFroms() {
        return this.froms;
    }

    public CompositeExpression getWhere() {
        return this.where;
    }

    public FieldAliasList getGroupBys() {
        return this.groupBys;
    }

    public CompositeExpression getHavings() {
        return this.havings;
    }

    public FieldAliasList getOrderBys() {
        return this.orderBys;
    }

    public void prepareTableAlias() {
        Iterator i = this.getFields().iterator();
        while (i.hasNext()) {
            this.addTableAlias((FieldAlias)i.next());
        }
        this.prepareTableAliasForExpression(this.getWhere());
        i = this.getGroupBys().iterator();
        while (i.hasNext()) {
            this.addTableAlias((FieldAlias)i.next());
        }
        this.prepareTableAliasForExpression(this.getHavings());
        i = this.getOrderBys().iterator();
        while (i.hasNext()) {
            this.addTableAlias((FieldAlias)i.next());
        }
    }

    private void prepareTableAliasForExpression(IExpression expression) {
        if (expression instanceof CompositeExpression) {
            CompositeExpression compo = (CompositeExpression)expression;
            Iterator i = compo.iterator();
            while (i.hasNext()) {
                this.prepareTableAliasForExpression((IExpression)i.next());
            }
        } else if (expression instanceof FieldExpression) {
            FieldExpression fieldExpression = (FieldExpression)expression;
            this.addTableAlias(fieldExpression.getField());
        } else if (expression instanceof FieldCompare) {
            FieldCompare fieldCompare = (FieldCompare)expression;
            this.addTableAlias(fieldCompare.getLeft());
            this.addTableAlias(fieldCompare.getRight());
        }
    }

    private void addTableAlias(FieldAlias fieldAlias) {
        if (!this.getFroms().contains(fieldAlias.getOwner())) {
            this.getFroms().add(fieldAlias.getOwner());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    class SelectFieldAliasList
    extends FieldAliasList {
        private final Select select;

        public SelectFieldAliasList(Select select2) {
            this.select = select2;
        }

        public boolean add(FieldAlias alias) {
            this.select.addFrom(alias.getOwnerAlias());
            return super.add(alias);
        }
    }

    class SelectComposite
    extends CompositeExpression {
        private final Select select;

        public SelectComposite(Select select2, String operator) {
            super(operator);
            this.select = select2;
        }

        private void addTableAlias(FieldAlias field) {
            this.select.addFrom(field.getOwnerAlias());
        }

        public CompositeExpression add(IExpression expression) {
            if (expression instanceof IFieldValuedExpression) {
                IFieldValuedExpression fieldExpression = (IFieldValuedExpression)expression;
                this.addTableAlias(fieldExpression.getField());
            } else if (expression instanceof IFieldCompare) {
                IFieldCompare fieldCompare = (IFieldCompare)expression;
                this.addTableAlias(fieldCompare.getLeft());
                this.addTableAlias(fieldCompare.getRight());
            }
            return super.add(expression);
        }

        public CompositeExpression addCompo(String operator) {
            SelectComposite result = new SelectComposite(this.select, operator);
            this.add(result);
            return result;
        }
    }
}

