/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.sql;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.brownie.core.sql.Conditions;
import org.asyrinx.brownie.core.sql.DynamicSelect;
import org.asyrinx.brownie.core.sql.Fields;
import org.asyrinx.brownie.core.sql.IBuilder;
import org.asyrinx.brownie.core.sql.Operator;
import org.asyrinx.brownie.core.sql.Tables;

public class BasicSqlBuilder
implements IBuilder {
    private char tablePrefixDelimiter = (char)46;
    private String aliasSigniture = "as";
    private String indexPrefix = "( INDEX ";
    private String indexSuffix = ")";
    private char quote = (char)39;

    public String buildField(String tableAlias, String fieldName, String aliasName, String functionName) {
        StringBuffer val = new StringBuffer();
        if (StringUtils.isNotEmpty((String)functionName)) {
            val.append(functionName);
            val.append("(");
        }
        if (StringUtils.isNotEmpty((String)tableAlias)) {
            val.append(tableAlias);
            val.append(this.getTablePrefixDelimiter());
        }
        val.append(fieldName);
        if (StringUtils.isNotEmpty((String)functionName)) {
            val.append(")");
        }
        if (StringUtils.isNotEmpty((String)aliasName)) {
            if (StringUtils.isNotEmpty((String)this.getAliasSigniture())) {
                val.append(" ");
                val.append(this.getAliasSigniture());
                val.append(" ");
            }
            val.append(aliasName);
        }
        return val.toString();
    }

    public String buildTable(String tablePrefix, String tableName, String tableAlias, String indexName) {
        StringBuffer result = new StringBuffer();
        if (StringUtils.isNotEmpty((String)tablePrefix)) {
            if (tablePrefix.charAt(tablePrefix.length() - 1) != this.getTablePrefixDelimiter()) {
                tablePrefix = String.valueOf(tablePrefix) + this.getTablePrefixDelimiter();
            }
            result.append(tablePrefix);
        }
        result.append(tableName);
        if (StringUtils.isNotEmpty((String)tableAlias)) {
            result.append(" ");
            result.append(tableAlias);
        }
        if (StringUtils.isNotEmpty((String)indexName)) {
            result.append(" ");
            result.append(String.valueOf(this.getIndexPrefix()) + indexName + this.getIndexSuffix());
        }
        return result.toString();
    }

    public String buildCondition(String fieldName, String value, Operator operator, boolean withQuote) {
        if (operator == null) {
            operator = Operator.EQUAL;
        }
        if (withQuote) {
            value = String.valueOf(this.getQuote()) + value + this.getQuote();
        }
        return String.valueOf(fieldName) + " " + operator.toString() + " " + value;
    }

    public void build(DynamicSelect dynamicSelect, StringBuffer dest) {
        this.buildSelect(dest, dynamicSelect);
        this.buildFrom(dest, dynamicSelect.getFromTables());
        this.buildWhere(dest, dynamicSelect.getWhereConditions());
        this.buildGroupBy(dest, dynamicSelect.getGroupByFields());
        this.buildHaving(dest, dynamicSelect.getHavingConditions());
        this.buildOrderBy(dest, dynamicSelect.getOrderByFields());
    }

    protected void buildSelect(StringBuffer dest, DynamicSelect dynamicSelect) {
        if (dynamicSelect.getSelectFields().isEmpty()) {
            return;
        }
        dest.append("select ");
        if (dynamicSelect.isDistinct()) {
            dest.append(" distinct ");
        }
        this.buildFields(dest, dynamicSelect.getSelectFields());
        dest.append(" ");
    }

    protected void buildFrom(StringBuffer dest, Tables fromTables) {
        if (fromTables.isEmpty()) {
            return;
        }
        dest.append("from ");
        this.buildTables(dest, fromTables);
        dest.append(" ");
    }

    protected void buildWhere(StringBuffer dest, Conditions conditions) {
        if (conditions.isEmpty()) {
            return;
        }
        dest.append("where ");
        this.buildConditions(dest, conditions);
        dest.append(" ");
    }

    protected void buildGroupBy(StringBuffer dest, Fields groupByFields) {
        if (groupByFields.isEmpty()) {
            return;
        }
        dest.append("group by ");
        this.buildFields(dest, groupByFields);
        dest.append(" ");
    }

    protected void buildHaving(StringBuffer dest, Conditions havingConditions) {
        if (havingConditions.isEmpty()) {
            return;
        }
        dest.append("having ");
        this.buildConditions(dest, havingConditions);
        dest.append(" ");
    }

    protected void buildOrderBy(StringBuffer dest, Fields orderByFields) {
        if (orderByFields.isEmpty()) {
            return;
        }
        dest.append("order by ");
        this.buildFields(dest, orderByFields);
        dest.append(" ");
    }

    protected void buildFields(StringBuffer dest, Fields fields) {
        Iterator iterator = fields.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            if (first) {
                first = false;
            } else {
                dest.append(fields.getDelimiter());
            }
            Object field = iterator.next();
            if (field instanceof Fields) {
                this.buildFields(dest, (Fields)field);
                continue;
            }
            dest.append(field);
        }
    }

    protected void buildTables(StringBuffer dest, Tables tables) {
        Iterator iterator = tables.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            if (first) {
                first = false;
            } else {
                dest.append(tables.getDelimiter());
            }
            Object table = iterator.next();
            if (table instanceof Tables) {
                this.buildTables(dest, (Tables)table);
                continue;
            }
            dest.append(table);
        }
    }

    protected void buildConditions(StringBuffer dest, Conditions conditions) {
        Iterator iterator = conditions.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            if (first) {
                first = false;
            } else {
                dest.append(" ");
                dest.append(conditions.getConnection());
                dest.append(" ");
            }
            Object condition = iterator.next();
            if (condition instanceof Conditions) {
                dest.append("(");
                this.buildConditions(dest, (Conditions)condition);
                dest.append(")");
                continue;
            }
            dest.append(condition);
        }
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public String getIndexSuffix() {
        return this.indexSuffix;
    }

    public char getTablePrefixDelimiter() {
        return this.tablePrefixDelimiter;
    }

    public void setIndexPrefix(String string) {
        this.indexPrefix = string;
    }

    public void setIndexSuffix(String string) {
        this.indexSuffix = string;
    }

    public void setTablePrefixDelimiter(char string) {
        this.tablePrefixDelimiter = string;
    }

    public char getQuote() {
        return this.quote;
    }

    public void setQuote(char c) {
        this.quote = c;
    }

    public String getAliasSigniture() {
        return this.aliasSigniture;
    }

    public void setAliasSigniture(String string) {
        this.aliasSigniture = string;
    }
}

