/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.sql2;

import java.util.Date;
import org.asyrinx.brownie.core.sql.Operator;
import org.asyrinx.brownie.core.sql2.Condition;
import org.asyrinx.brownie.core.sql2.Elements;
import org.asyrinx.brownie.core.sql2.Visitor;

public class Conditions
extends Elements {
    private Operator connection = Operator.AND;

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public Operator getConnection() {
        return this.connection;
    }

    public void setConnection(Operator operator) {
        this.connection = operator;
    }

    public Conditions addNewCondition() {
        return this.addNewConditions(this.getConnection());
    }

    public Conditions addNewConditions(Operator conn) {
        Conditions result = new Conditions();
        result.setConnection(conn);
        super.addImpl(result);
        return result;
    }

    public Conditions addPlainCondition(String condition) {
        return this.add(null, condition, Operator.NONE);
    }

    public Conditions add(String field, Object value, Operator operator) {
        Condition result = new Condition();
        result.setFieldName(field);
        result.setOperator(operator);
        result.setValue(value);
        result.setConditions(this);
        super.addImpl(result);
        return this;
    }

    public Conditions addRange(String field, Object min, Object max) {
        return this.addRange(field, min, max, true, true);
    }

    public Conditions addRange(String field, Object min, Object max, boolean includeMin, boolean includeMax) {
        Conditions conditions = this.addNewConditions(Operator.AND);
        if (includeMin) {
            conditions.add(field, min, Operator.GREATER_EQUAL);
        } else {
            conditions.add(field, min, Operator.GREATER_THAN);
        }
        if (includeMax) {
            conditions.add(field, max, Operator.LESS_EQUAL);
        } else {
            conditions.add(field, max, Operator.LESS_THAN);
        }
        return this;
    }

    public Conditions add(String field, String value) {
        return this.add(field, value, Operator.EQUAL);
    }

    public Conditions add(String field, String value, Operator operater) {
        return this.add(field, (Object)value, operater);
    }

    public Conditions add(String field, int value) {
        return this.add(field, value, Operator.EQUAL);
    }

    public Conditions add(String field, int value, Operator operater) {
        return this.add(field, new Integer(value), operater);
    }

    public Conditions addRange(String field, int min, int max, boolean includeMin, boolean includeMax) {
        return this.addRange(field, new Integer(min), new Integer(max), includeMin, includeMax);
    }

    public Conditions add(String field, long value) {
        return this.add(field, value, Operator.EQUAL);
    }

    public Conditions add(String field, long value, Operator operater) {
        return this.add(field, new Long(value), operater);
    }

    public Conditions addRange(String field, long min, long max, boolean includeMin, boolean includeMax) {
        return this.addRange(field, new Long(min), new Long(max), includeMin, includeMax);
    }

    public Conditions add(String field, Date value) {
        return this.add(field, value, Operator.EQUAL);
    }

    public Conditions add(String field, Date value, Operator operater) {
        return this.add(field, (Object)value, operater);
    }

    public Conditions addRange(String field, Date beginDate, Date endDate) {
        return this.addRange(field, beginDate, endDate, true, true);
    }

    public Conditions addRange(String field, Date beginDate, Date endDate, boolean includeMin, boolean includeMax) {
        return this.addRange(field, (Object)beginDate, (Object)endDate, includeMin, includeMax);
    }
}

