/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class DateUtils {
    private static final Date INFINITE_PAST = new Date(){

        public long getTime() {
            return Long.MIN_VALUE;
        }

        public void setTime(long time) {
            StringBuffer stringBuffer = new StringBuffer("cannot set time");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.asyrinx.brownie.core.util.DateUtils");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new UnsupportedOperationException(stringBuffer.append(clazz.getName()).append(".INFINITE_PAST").toString());
        }
    };
    private static final Date INFINITE_FUTURE = new Date(){

        public long getTime() {
            return Long.MAX_VALUE;
        }

        public void setTime(long time) {
            StringBuffer stringBuffer = new StringBuffer("cannot set time to ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.asyrinx.brownie.core.util.DateUtils");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new UnsupportedOperationException(stringBuffer.append(clazz.getName()).append(".INFINITE_FUTURE").toString());
        }
    };
    static /* synthetic */ Class class$0;

    public static Date getInfinitePast() {
        return INFINITE_PAST;
    }

    public static Date getInfiniteFuture() {
        return INFINITE_FUTURE;
    }

    public static boolean isInfinitePast(Date date) {
        return date != null ? date.getTime() == Long.MIN_VALUE : false;
    }

    public static boolean isInfiniteFuture(Date date) {
        return date != null ? date.getTime() == Long.MAX_VALUE : false;
    }

    public static Date toDateTime(int year, int month, int day, int hours, int minuites, int seconds, int milliseconds) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, hours, minuites, seconds);
        cal.set(14, milliseconds);
        return new Date(cal.getTime().getTime());
    }

    public static Date adjustDateTime(Date d, int hours, int minuites, int seconds, int miliseconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return DateUtils.toDateTime(cal.get(1), cal.get(2), cal.get(5), hours, minuites, seconds, miliseconds);
    }

    public static Date adjustDateBegin(Date d) {
        return DateUtils.adjustDateTime(d, 0, 0, 0, 0);
    }

    public static Date adjustDateEnd(Date d) {
        return DateUtils.adjustDateTime(d, 23, 59, 59, 999);
    }

    public static int get(Date d, int calendarField) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(calendarField);
    }

    public static int getYear(Date d) {
        return DateUtils.get(d, 1);
    }

    public static int getMonth(Date d) {
        return DateUtils.get(d, 2);
    }

    public static int getDay(Date d) {
        return DateUtils.get(d, 5);
    }

    public static Date toDate(int year, int month, int day) {
        return DateUtils.toDate(year, month, day, 0, 0);
    }

    public static Date toDate(int year, int month, int day, int hours, int minutes) {
        return DateUtils.toDate(year, month, day, hours, minutes, 0);
    }

    public static Date toDate(int year, int month, int day, int hours, int minutes, int seconds) {
        return DateUtils.toDate(year, month, day, hours, minutes, seconds, 0);
    }

    public static Date toDate(int year, int month, int day, int hours, int minutes, int seconds, int milliseconds) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, hours, minutes, seconds);
        cal.set(14, milliseconds);
        return new Date(cal.getTime().getTime());
    }

    public static Date toDateBegin(int y, int m, int d) {
        return DateUtils.toDateTime(y, m, d, 0, 0, 0, 0);
    }

    public static Date toDateEnd(int y, int m, int d) {
        return DateUtils.toDateTime(y, m, d, 23, 59, 59, 999);
    }

    public static boolean isLeapYear(int year) {
        GregorianCalendar calendar = new GregorianCalendar();
        return calendar.isLeapYear(year);
    }

    public static Date getBeginDateOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, 1);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date getLastDateOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, DateUtils.getLastDayOfMonth(year, month));
        return new Date(calendar.getTimeInMillis());
    }

    public static int getLastDayOfMonth(int year, int month) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, 1);
        return calendar.getActualMaximum(5);
    }
}

