/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.xml.dom.impl;

import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.asyrinx.brownie.core.xml.dom.DomBuilder;
import org.asyrinx.brownie.core.xml.dom.XmlBeanWriter;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlBeanWriterImpl
implements XmlBeanWriter {
    protected final DomBuilder domBuilder;
    private String encoding = "Shift_JIS";
    private boolean indent = true;

    public XmlBeanWriterImpl(DomBuilder domBuilder) {
        this.domBuilder = domBuilder;
    }

    public void execute(Object bean, OutputStream domDest, String rootName) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        DOMImplementation domImpl = builder.getDOMImplementation();
        Document document = domImpl.createDocument("", rootName, null);
        Element root = document.getDocumentElement();
        this.domBuilder.prepareRoot(root, bean);
        this.domBuilder.execute(document, bean, root);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("encoding", this.getEncoding());
        transformer.setOutputProperty("indent", this.getIndentValue());
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(domDest);
        transformer.transform(source, result);
    }

    public String getIndentValue() {
        return this.isIndent() ? "yes" : "no";
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }
}

