/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.log.log4j.servlet;

import javax.servlet.ServletContext;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.xml.DOMConfigurator;
import org.asyrinx.brownie.log.log4j.servlet.ServletXmlWatchdog;
import org.asyrinx.brownie.servlet.FileNameResolver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServletDOMConfigurator
extends DOMConfigurator {
    protected final FileNameResolver resolver;
    static /* synthetic */ Class class$0;

    public ServletDOMConfigurator(ServletContext servletContext) {
        if (servletContext == null) {
            throw new RuntimeException("servletContext == null");
        }
        this.resolver = new FileNameResolver(servletContext);
    }

    protected Appender parseAppender(Element appenderElement) {
        String className = this.subst(appenderElement.getAttribute("class"));
        LogLog.debug((String)("Class name: [" + className + ']'));
        try {
            Object instance = Loader.loadClass((String)className).newInstance();
            Appender appender = (Appender)instance;
            PropertySetter propSetter = new PropertySetter((Object)appender);
            appender.setName(this.subst(appenderElement.getAttribute("name")));
            NodeList children = appenderElement.getChildNodes();
            int length = children.getLength();
            int loop = 0;
            while (loop < length) {
                Node currentNode = children.item(loop);
                if (currentNode.getNodeType() == 1) {
                    Element currentElement = (Element)currentNode;
                    if (currentElement.getTagName().equals("param")) {
                        if ("file".equalsIgnoreCase(currentElement.getAttribute("name"))) {
                            currentElement.setAttribute("value", this.resolver.toRealPath(currentElement.getAttribute("value")));
                        }
                        this.setParameter(currentElement, propSetter);
                    } else if (currentElement.getTagName().equals("layout")) {
                        appender.setLayout(this.parseLayout(currentElement));
                    } else if (currentElement.getTagName().equals("filter")) {
                        this.parseFilters(currentElement, appender);
                    } else if (currentElement.getTagName().equals("errorHandler")) {
                        this.parseErrorHandler(currentElement, appender);
                    } else if (currentElement.getTagName().equals("appender-ref")) {
                        String refName = this.subst(currentElement.getAttribute("ref"));
                        if (appender instanceof AppenderAttachable) {
                            AppenderAttachable aa = (AppenderAttachable)appender;
                            LogLog.debug((String)("Attaching appender named [" + refName + "] to appender named [" + appender.getName() + "]."));
                            aa.addAppender(this.findAppenderByReference(currentElement));
                        } else {
                            LogLog.error((String)("Requesting attachment of appender named [" + refName + "] to appender named [" + appender.getName() + "] which does not implement org.apache.log4j.spi.AppenderAttachable."));
                        }
                    }
                }
                ++loop;
            }
            propSetter.activate();
            return appender;
        }
        catch (Exception oops) {
            LogLog.error((String)"Could not create an Appender. Reported error follows.", (Throwable)oops);
            return null;
        }
    }

    public static void configure(String configFilename, ServletContext servletContext) {
        if (servletContext == null) {
            throw new RuntimeException("servletContext == null");
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.asyrinx.brownie.log.log4j.servlet.ServletDOMConfigurator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        servletContext.log(String.valueOf(clazz.getName()) + "#configure(\"" + configFilename + "\")");
        ServletDOMConfigurator configurator = new ServletDOMConfigurator(servletContext);
        configurator.doConfigure(configFilename, LogManager.getLoggerRepository());
    }

    public static void configureAndWatch(String configFilename, ServletContext servletContext) {
        if (servletContext == null) {
            throw new RuntimeException("servletContext == null");
        }
        ServletDOMConfigurator.configureAndWatch(configFilename, 60000L, servletContext);
    }

    public static void configureAndWatch(String configFilename, long delay, ServletContext servletContext) {
        if (servletContext == null) {
            throw new RuntimeException("servletContext == null");
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.asyrinx.brownie.log.log4j.servlet.ServletDOMConfigurator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        servletContext.log(String.valueOf(clazz.getName()) + "#configureAndWatch(\"" + configFilename + "\")");
        ServletXmlWatchdog xdog = new ServletXmlWatchdog(configFilename, servletContext);
        xdog.setDelay(delay);
        xdog.start();
    }
}

