/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.seasar.dbcp.logger;

import java.sql.SQLException;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.seasar.dbcp.logger.LogConnectionWrapper;
import org.asyrinx.brownie.seasar.dbcp.wrapper.ConnectionPoolWrapper;
import org.seasar.extension.dbcp.ConnectionPool;
import org.seasar.extension.dbcp.ConnectionWrapper;

public class LogConnectionPool
extends ConnectionPoolWrapper {
    protected final CascadeNamedLog log;

    public LogConnectionPool(ConnectionPool wrapped) {
        this(wrapped, new CascadeNamedLog(wrapped.getClass(), "debug"));
    }

    public LogConnectionPool(ConnectionPool wrapped, String name) {
        this(wrapped, new CascadeNamedLog(name, "debug"));
    }

    public LogConnectionPool(ConnectionPool wrapped, CascadeNamedLog log) {
        super(wrapped);
        this.log = log;
    }

    public void checkIn(ConnectionWrapper connectionWrapper) {
        try {
            super.checkIn(connectionWrapper);
            this.log.log("checkIn(" + connectionWrapper + ")");
        }
        catch (RuntimeException e) {
            this.log.error("failed to checkIn(" + connectionWrapper + ")", e);
            throw e;
        }
    }

    public ConnectionWrapper checkOut() throws SQLException {
        try {
            ConnectionWrapper result = super.checkOut();
            this.log.log("checkOut(): " + result);
            return new LogConnectionWrapper(result, this.log.subLog(result));
        }
        catch (SQLException e) {
            this.log.error("failed to checkIn()", e);
            throw e;
        }
    }

    public void close() {
        try {
            super.close();
            this.log.log("close()");
        }
        catch (RuntimeException e) {
            this.log.error("failed to close()", e);
            throw e;
        }
    }

    public void release(ConnectionWrapper connectionWrapper) {
        try {
            super.release(connectionWrapper);
            this.log.log("release(" + connectionWrapper + ")");
        }
        catch (RuntimeException e) {
            this.log.error("release(" + connectionWrapper + ")", e);
            throw e;
        }
    }
}

